package software.amazon.awscdk.core;

/**
 * Custom resource that is implemented using a Lambda.
 * <p>
 * As a custom resource author, you should be publishing a subclass of this class
 * that hides the choice of provider, and accepts a strongly-typed properties
 * object with the properties your provider accepts.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-24T22:28:57.999Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CustomResource")
public class CustomResource extends software.amazon.awscdk.core.Resource {

    protected CustomResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomResource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CustomResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the value of an attribute of the custom resource of an arbitrary type.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @return a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     * @param attributeName the name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * Returns the value of an attribute of the custom resource of type string.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @return a token for `Fn::GetAtt` encoded as a string.
     * @param attributeName the name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttString(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAttString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * The physical name of this custom resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRef() {
        return software.amazon.jsii.Kernel.get(this, "ref", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CustomResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CustomResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CustomResourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CustomResourceProps.Builder();
        }

        /**
         * The ARN of the provider which implements this custom resource type.
         * <p>
         * You can implement a provider by listening to raw AWS CloudFormation events
         * and specify the ARN of an SNS topic (<code>topic.topicArn</code>) or the ARN of an AWS
         * Lambda function (<code>lambda.functionArn</code>) or use the CDK's custom <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html">resource
         * provider framework</a> which makes it easier to implement robust providers.
         * <p>
         * Provider framework:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * // use the provider framework from aws-cdk/custom-resources:
         * var provider = Provider.Builder.create()
         *         .onEventHandler(myOnEventLambda)
         *         .isCompleteHandler(myIsCompleteLambda)
         *         .build();
         * CustomResource.Builder.create(this, "MyResource")
         *         .serviceToken(provider.getServiceToken())
         *         .build();
         * </pre></blockquote>
         * <p>
         * AWS Lambda function:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * serviceToken: myFunction.functionArn
         * </pre></blockquote>
         * <p>
         * SNS topic:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * serviceToken: myTopic.topicArn
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param serviceToken The ARN of the provider which implements this custom resource type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceToken(final java.lang.String serviceToken) {
            this.props.serviceToken(serviceToken);
            return this;
        }

        /**
         * Convert all property keys to pascal case.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param pascalCaseProperties Convert all property keys to pascal case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pascalCaseProperties(final java.lang.Boolean pascalCaseProperties) {
            this.props.pascalCaseProperties(pascalCaseProperties);
            return this;
        }

        /**
         * Properties to pass to the Lambda.
         * <p>
         * Default: - No properties.
         * <p>
         * @return {@code this}
         * @param properties Properties to pass to the Lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * The policy to apply when this resource is removed from the application.
         * <p>
         * Default: cdk.RemovalPolicy.Destroy
         * <p>
         * @return {@code this}
         * @param removalPolicy The policy to apply when this resource is removed from the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
         * <p>
         * For example, you can use "Custom::MyCustomResourceTypeName".
         * <p>
         * Custom resource type names must begin with "Custom::" and can include
         * alphanumeric characters and the following characters: _&#64;-. You can specify
         * a custom resource type name up to a maximum length of 60 characters. You
         * cannot change the type during an update.
         * <p>
         * Using your own resource type names helps you quickly differentiate the
         * types of custom resources in your stack. For example, if you had two custom
         * resources that conduct two different ping tests, you could name their type
         * as Custom::PingTester to make them easily identifiable as ping testers
         * (instead of using AWS::CloudFormation::CustomResource).
         * <p>
         * Default: - AWS::CloudFormation::CustomResource
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name
         * @param resourceType For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CustomResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.CustomResource build() {
            return new software.amazon.awscdk.core.CustomResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
