package software.amazon.awscdk.core;

/**
 * A Docker image used for asset bundling.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-24T22:28:57.445Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.BundlingDockerImage")
public class BundlingDockerImage extends software.amazon.jsii.JsiiObject {

    protected BundlingDockerImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BundlingDockerImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Reference an image that's built directly from sources on disk.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     * @param options Docker build options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.BundlingDockerImage fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerBuildOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.BundlingDockerImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.BundlingDockerImage.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Reference an image that's built directly from sources on disk.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.BundlingDockerImage fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.BundlingDockerImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.BundlingDockerImage.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Reference an image on DockerHub or another online registry.
     * <p>
     * @param image the image name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.BundlingDockerImage fromRegistry(final @org.jetbrains.annotations.NotNull java.lang.String image) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.BundlingDockerImage.class, "fromRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.BundlingDockerImage.class), new Object[] { java.util.Objects.requireNonNull(image, "image is required") });
    }

    /**
     * Copies a file or directory out of the Docker image to the local filesystem.
     * <p>
     * @param imagePath This parameter is required.
     * @param outputPath This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void cp(final @org.jetbrains.annotations.NotNull java.lang.String imagePath, final @org.jetbrains.annotations.NotNull java.lang.String outputPath) {
        software.amazon.jsii.Kernel.call(this, "cp", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(imagePath, "imagePath is required"), java.util.Objects.requireNonNull(outputPath, "outputPath is required") });
    }

    /**
     * Runs a Docker image.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void run(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerRunOptions options) {
        software.amazon.jsii.Kernel.call(this, "run", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * Runs a Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void run() {
        software.amazon.jsii.Kernel.call(this, "run", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Provides a stable representation of this image for JSON serialization.
     * <p>
     * @return The overridden image name if set or image hash name in that order
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImage() {
        return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
