/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnStackSet;
import software.amazon.awscdk.core.CfnStackSetProps;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStackSet")
public class CfnStackSet
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStackSet.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnStackSet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStackSet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStackSet(@NotNull Construct scope, @NotNull String id, @Nullable CfnStackSetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnStackSet(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrStackSetId() {
        return (String)this.jsiiGet("attrStackSetId", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @Nullable
    public String getAdministrationRoleArn() {
        return (String)this.jsiiGet("administrationRoleArn", String.class);
    }

    public void setAdministrationRoleArn(@Nullable String value) {
        this.jsiiSet("administrationRoleArn", value);
    }

    @Nullable
    public Object getAutoDeployment() {
        return this.jsiiGet("autoDeployment", Object.class);
    }

    public void setAutoDeployment(@Nullable IResolvable value) {
        this.jsiiSet("autoDeployment", value);
    }

    public void setAutoDeployment(@Nullable AutoDeploymentProperty value) {
        this.jsiiSet("autoDeployment", value);
    }

    @Nullable
    public List<String> getCapabilities() {
        return Optional.ofNullable((List)this.jsiiGet("capabilities", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCapabilities(@Nullable List<String> value) {
        this.jsiiSet("capabilities", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getExecutionRoleName() {
        return (String)this.jsiiGet("executionRoleName", String.class);
    }

    public void setExecutionRoleName(@Nullable String value) {
        this.jsiiSet("executionRoleName", value);
    }

    @Nullable
    public Object getOperationPreferences() {
        return this.jsiiGet("operationPreferences", Object.class);
    }

    public void setOperationPreferences(@Nullable IResolvable value) {
        this.jsiiSet("operationPreferences", value);
    }

    public void setOperationPreferences(@Nullable OperationPreferencesProperty value) {
        this.jsiiSet("operationPreferences", value);
    }

    @Nullable
    public Object getParameters() {
        return this.jsiiGet("parameters", Object.class);
    }

    public void setParameters(@Nullable IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    public void setParameters(@Nullable List<Object> value) {
        this.jsiiSet("parameters", value);
    }

    @Nullable
    public String getPermissionModel() {
        return (String)this.jsiiGet("permissionModel", String.class);
    }

    public void setPermissionModel(@Nullable String value) {
        this.jsiiSet("permissionModel", value);
    }

    @Nullable
    public Object getStackInstancesGroup() {
        return this.jsiiGet("stackInstancesGroup", Object.class);
    }

    public void setStackInstancesGroup(@Nullable IResolvable value) {
        this.jsiiSet("stackInstancesGroup", value);
    }

    public void setStackInstancesGroup(@Nullable List<Object> value) {
        this.jsiiSet("stackInstancesGroup", value);
    }

    @Nullable
    public String getStackSetName() {
        return (String)this.jsiiGet("stackSetName", String.class);
    }

    public void setStackSetName(@Nullable String value) {
        this.jsiiSet("stackSetName", value);
    }

    @Nullable
    public String getTemplateBody() {
        return (String)this.jsiiGet("templateBody", String.class);
    }

    public void setTemplateBody(@Nullable String value) {
        this.jsiiSet("templateBody", value);
    }

    @Nullable
    public String getTemplateUrl() {
        return (String)this.jsiiGet("templateUrl", String.class);
    }

    public void setTemplateUrl(@Nullable String value) {
        this.jsiiSet("templateUrl", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStackSet> {
        private final Construct scope;
        private final String id;
        private CfnStackSetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder administrationRoleArn(String administrationRoleArn) {
            this.props().administrationRoleArn(administrationRoleArn);
            return this;
        }

        public Builder autoDeployment(IResolvable autoDeployment) {
            this.props().autoDeployment(autoDeployment);
            return this;
        }

        public Builder autoDeployment(AutoDeploymentProperty autoDeployment) {
            this.props().autoDeployment(autoDeployment);
            return this;
        }

        public Builder capabilities(List<String> capabilities) {
            this.props().capabilities(capabilities);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder executionRoleName(String executionRoleName) {
            this.props().executionRoleName(executionRoleName);
            return this;
        }

        public Builder operationPreferences(IResolvable operationPreferences) {
            this.props().operationPreferences(operationPreferences);
            return this;
        }

        public Builder operationPreferences(OperationPreferencesProperty operationPreferences) {
            this.props().operationPreferences(operationPreferences);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder parameters(List<? extends Object> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder permissionModel(String permissionModel) {
            this.props().permissionModel(permissionModel);
            return this;
        }

        public Builder stackInstancesGroup(IResolvable stackInstancesGroup) {
            this.props().stackInstancesGroup(stackInstancesGroup);
            return this;
        }

        public Builder stackInstancesGroup(List<? extends Object> stackInstancesGroup) {
            this.props().stackInstancesGroup(stackInstancesGroup);
            return this;
        }

        public Builder stackSetName(String stackSetName) {
            this.props().stackSetName(stackSetName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder templateBody(String templateBody) {
            this.props().templateBody(templateBody);
            return this;
        }

        public Builder templateUrl(String templateUrl) {
            this.props().templateUrl(templateUrl);
            return this;
        }

        public CfnStackSet build() {
            return new CfnStackSet(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnStackSetProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnStackSetProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStackSet.StackInstancesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StackInstancesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDeploymentTargets();

        @NotNull
        public List<String> getRegions();

        @Nullable
        default public Object getParameterOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StackInstancesProperty> {
            private Object deploymentTargets;
            private List<String> regions;
            private Object parameterOverrides;

            public Builder deploymentTargets(IResolvable deploymentTargets) {
                this.deploymentTargets = deploymentTargets;
                return this;
            }

            public Builder deploymentTargets(DeploymentTargetsProperty deploymentTargets) {
                this.deploymentTargets = deploymentTargets;
                return this;
            }

            public Builder regions(List<String> regions) {
                this.regions = regions;
                return this;
            }

            public Builder parameterOverrides(IResolvable parameterOverrides) {
                this.parameterOverrides = parameterOverrides;
                return this;
            }

            public Builder parameterOverrides(List<? extends Object> parameterOverrides) {
                this.parameterOverrides = parameterOverrides;
                return this;
            }

            public StackInstancesProperty build() {
                return new Jsii.Proxy(this.deploymentTargets, this.regions, this.parameterOverrides, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStackSet.ParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterKey();

        @NotNull
        public String getParameterValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterProperty> {
            private String parameterKey;
            private String parameterValue;

            public Builder parameterKey(String parameterKey) {
                this.parameterKey = parameterKey;
                return this;
            }

            public Builder parameterValue(String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            public ParameterProperty build() {
                return new Jsii.Proxy(this.parameterKey, this.parameterValue, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStackSet.OperationPreferencesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OperationPreferencesProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getFailureToleranceCount() {
            return null;
        }

        @Nullable
        default public Number getFailureTolerancePercentage() {
            return null;
        }

        @Nullable
        default public Number getMaxConcurrentCount() {
            return null;
        }

        @Nullable
        default public Number getMaxConcurrentPercentage() {
            return null;
        }

        @Nullable
        default public List<String> getRegionOrder() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OperationPreferencesProperty> {
            private Number failureToleranceCount;
            private Number failureTolerancePercentage;
            private Number maxConcurrentCount;
            private Number maxConcurrentPercentage;
            private List<String> regionOrder;

            public Builder failureToleranceCount(Number failureToleranceCount) {
                this.failureToleranceCount = failureToleranceCount;
                return this;
            }

            public Builder failureTolerancePercentage(Number failureTolerancePercentage) {
                this.failureTolerancePercentage = failureTolerancePercentage;
                return this;
            }

            public Builder maxConcurrentCount(Number maxConcurrentCount) {
                this.maxConcurrentCount = maxConcurrentCount;
                return this;
            }

            public Builder maxConcurrentPercentage(Number maxConcurrentPercentage) {
                this.maxConcurrentPercentage = maxConcurrentPercentage;
                return this;
            }

            public Builder regionOrder(List<String> regionOrder) {
                this.regionOrder = regionOrder;
                return this;
            }

            public OperationPreferencesProperty build() {
                return new Jsii.Proxy(this.failureToleranceCount, this.failureTolerancePercentage, this.maxConcurrentCount, this.maxConcurrentPercentage, this.regionOrder, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStackSet.DeploymentTargetsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentTargetsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAccounts() {
            return null;
        }

        @Nullable
        default public List<String> getOrganizationalUnitIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentTargetsProperty> {
            private List<String> accounts;
            private List<String> organizationalUnitIds;

            public Builder accounts(List<String> accounts) {
                this.accounts = accounts;
                return this;
            }

            public Builder organizationalUnitIds(List<String> organizationalUnitIds) {
                this.organizationalUnitIds = organizationalUnitIds;
                return this;
            }

            public DeploymentTargetsProperty build() {
                return new Jsii.Proxy(this.accounts, this.organizationalUnitIds, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStackSet.AutoDeploymentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoDeploymentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getRetainStacksOnAccountRemoval() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoDeploymentProperty> {
            private Object enabled;
            private Object retainStacksOnAccountRemoval;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder retainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval) {
                this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
                return this;
            }

            public Builder retainStacksOnAccountRemoval(IResolvable retainStacksOnAccountRemoval) {
                this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
                return this;
            }

            public AutoDeploymentProperty build() {
                return new Jsii.Proxy(this.enabled, this.retainStacksOnAccountRemoval, null);
            }
        }
    }
}

