package software.amazon.awscdk.core;

/**
 * (experimental) A CloudFormation nested stack.
 * <p>
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 * <p>
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 * <p>
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-02T20:10:51.293Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.NestedStack")
public class NestedStack extends software.amazon.awscdk.core.Stack {

    protected NestedStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NestedStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public NestedStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.NestedStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public NestedStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Checks if `x` is an object of type `NestedStack`.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isNestedStack(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.NestedStack.class, "isNestedStack", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * (experimental) Assign a value to one of the nested stack parameters.
     * <p>
     * @param name The parameter name (ID). This parameter is required.
     * @param value The value to assign. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setParameter(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiCall("setParameter", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) An attribute that represents the ID of the stack.
     * <p>
     * This is a context aware attribute:
     * <p>
     * <ul>
     * <li>If this is referenced from the parent stack, it will return <code>{ "Ref": "LogicalIdOfNestedStackResource" }</code>.</li>
     * <li>If this is referenced from the context of the nested stack, it will return <code>{ "Ref": "AWS::StackId" }</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "arn:aws:cloudformation:us-east-2:123456789012:stack/mystack-mynestedstack-sggfrhxhum7w/f449b250-b969-11e0-a185-5081d0136786";}</pre></blockquote>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackId() {
        return this.jsiiGet("stackId", java.lang.String.class);
    }

    /**
     * (experimental) An attribute that represents the name of the nested stack.
     * <p>
     * This is a context aware attribute:
     * <p>
     * <ul>
     * <li>If this is referenced from the parent stack, it will return a token that parses the name from the stack ID.</li>
     * <li>If this is referenced from the context of the nested stack, it will return <code>{ "Ref": "AWS::StackName" }</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * mystack - mynestedstack - sggfrhxhum7w;}</pre></blockquote>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return this.jsiiGet("stackName", java.lang.String.class);
    }

    /**
     * (experimental) The name of the CloudFormation template file emitted to the output directory during synthesis.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile() {
        return this.jsiiGet("templateFile", java.lang.String.class);
    }

    /**
     * (experimental) If this is a nested stack, this represents its `AWS::CloudFormation::Stack` resource.
     * <p>
     * <code>undefined</code> for top-level (non-nested) stacks.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnResource getNestedStackResource() {
        return this.jsiiGet("nestedStackResource", software.amazon.awscdk.core.CfnResource.class);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.core.NestedStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.NestedStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.NestedStackProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The Simple Notification Service (SNS) topics to publish stack related events.
         * <p>
         * Default: - notifications are not sent for this stack.
         * <p>
         * @return {@code this}
         * @param notificationArns The Simple Notification Service (SNS) topics to publish stack related events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        /**
         * (experimental) The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding
         * to a parameter defined in the embedded template and a value representing
         * the value that you want to set for the parameter.
         * <p>
         * The nested stack construct will automatically synthesize parameters in order
         * to bind references from the parent stack(s) into the nested stack.
         * <p>
         * Default: - no user-defined parameters are passed to the nested stack
         * <p>
         * @return {@code this}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * (experimental) The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
         * <p>
         * When CloudFormation detects that the nested stack has reached the
         * CREATE_COMPLETE state, it marks the nested stack resource as
         * CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
         * If the timeout period expires before the nested stack reaches
         * CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
         * back both the nested stack and parent stack.
         * <p>
         * Default: - no timeout
         * <p>
         * @return {@code this}
         * @param timeout The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.NestedStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.core.NestedStack build() {
            return new software.amazon.awscdk.core.NestedStack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.NestedStackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.NestedStackProps.Builder();
            }
            return this.props;
        }
    }
}
