package software.amazon.awscdk.core;

/**
 * Capabilities that affect whether CloudFormation is allowed to change IAM resources.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-09-25T17:38:57.408Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnCapabilities")
public enum CfnCapabilities {
    /**
     * No IAM Capabilities.
     * <p>
     * Pass this capability if you wish to block the creation IAM resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * Capability to create anonymous IAM resources.
     * <p>
     * Pass this capability if you're only creating anonymous resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANONYMOUS_IAM,
    /**
     * Capability to create named IAM resources.
     * <p>
     * Pass this capability if you're creating IAM resources that have physical
     * names.
     * <p>
     * <code>CloudFormationCapabilities.NamedIAM</code> implies <code>CloudFormationCapabilities.IAM</code>; you don't have to pass both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NAMED_IAM,
    /**
     * Capability to run CloudFormation macros.
     * <p>
     * Pass this capability if your template includes macros, for example AWS::Include or AWS::Serverless.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTO_EXPAND,
}
