package software.amazon.awscdk.core;

/**
 * A CloudFormation Hook for CodeDeploy blue-green ECS deployments.
 * <p>
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html#blue-green-template-reference
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-09-22T23:51:18.610Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnCodeDeployBlueGreenHook")
public class CfnCodeDeployBlueGreenHook extends software.amazon.awscdk.core.CfnHook {

    protected CfnCodeDeployBlueGreenHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCodeDeployBlueGreenHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new CodeDeploy blue-green ECS Hook.
     * <p>
     * @param scope the scope to create the hook in (usually the containing Stack object). This parameter is required.
     * @param id the identifier of the construct - will be used to generate the logical ID of the Hook. This parameter is required.
     * @param props the properties of the Hook. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCodeDeployBlueGreenHook(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnCodeDeployBlueGreenHookProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param _props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> _props) {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { _props }))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Properties of the Amazon ECS applications being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> getApplications() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication.class))));
    }

    /**
     * Properties of the Amazon ECS applications being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplications(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> value) {
        this.jsiiSet("applications", java.util.Objects.requireNonNull(value, "applications is required"));
    }

    /**
     * The IAM Role for CloudFormation to use to perform blue-green deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRole() {
        return this.jsiiGet("serviceRole", java.lang.String.class);
    }

    /**
     * The IAM Role for CloudFormation to use to perform blue-green deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("serviceRole", java.util.Objects.requireNonNull(value, "serviceRole is required"));
    }

    /**
     * Additional options for the blue/green deployment.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions getAdditionalOptions() {
        return this.jsiiGet("additionalOptions", software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions.class);
    }

    /**
     * Additional options for the blue/green deployment.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions value) {
        this.jsiiSet("additionalOptions", value);
    }

    /**
     * Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     * <p>
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     * <p>
     * Default: - no lifecycle event hooks
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks getLifecycleEventHooks() {
        return this.jsiiGet("lifecycleEventHooks", software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks.class);
    }

    /**
     * Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     * <p>
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     * <p>
     * Default: - no lifecycle event hooks
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleEventHooks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks value) {
        this.jsiiSet("lifecycleEventHooks", value);
    }

    /**
     * Traffic routing configuration settings.
     * <p>
     * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingConfig getTrafficRoutingConfig() {
        return this.jsiiGet("trafficRoutingConfig", software.amazon.awscdk.core.CfnTrafficRoutingConfig.class);
    }

    /**
     * Traffic routing configuration settings.
     * <p>
     * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficRoutingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingConfig value) {
        this.jsiiSet("trafficRoutingConfig", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope the scope to create the hook in (usually the containing Stack object). This parameter is required.
         * @param id the identifier of the construct - will be used to generate the logical ID of the Hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CfnCodeDeployBlueGreenHookProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CfnCodeDeployBlueGreenHookProps.Builder();
        }

        /**
         * Properties of the Amazon ECS applications being deployed.
         * <p>
         * @return {@code this}
         * @param applications Properties of the Amazon ECS applications being deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(final java.util.List<? extends software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * The IAM Role for CloudFormation to use to perform blue-green deployments.
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM Role for CloudFormation to use to perform blue-green deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * Additional options for the blue/green deployment.
         * <p>
         * Default: - no additional options
         * <p>
         * @return {@code this}
         * @param additionalOptions Additional options for the blue/green deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalOptions(final software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions additionalOptions) {
            this.props.additionalOptions(additionalOptions);
            return this;
        }

        /**
         * Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
         * <p>
         * You can use the same function or a different one for deployment lifecycle events.
         * Following completion of the validation tests,
         * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
         * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
         * <p>
         * Default: - no lifecycle event hooks
         * <p>
         * @return {@code this}
         * @param lifecycleEventHooks Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleEventHooks(final software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks lifecycleEventHooks) {
            this.props.lifecycleEventHooks(lifecycleEventHooks);
            return this;
        }

        /**
         * Traffic routing configuration settings.
         * <p>
         * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
         * <p>
         * @return {@code this}
         * @param trafficRoutingConfig Traffic routing configuration settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRoutingConfig(final software.amazon.awscdk.core.CfnTrafficRoutingConfig trafficRoutingConfig) {
            this.props.trafficRoutingConfig(trafficRoutingConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook build() {
            return new software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
