package software.amazon.awscdk.core;

/**
 * The RemoveTag Aspect will handle removing tags from this node and children.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-13T06:02:42.281Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.RemoveTag")
public class RemoveTag extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IAspect {

    protected RemoveTag(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RemoveTag(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param key This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RemoveTag(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TagProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), props });
    }

    /**
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RemoveTag(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void applyTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ITaggable resource) {
        this.jsiiCall("applyTag", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * All aspects can visit an IConstruct.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void visit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct construct) {
        this.jsiiCall("visit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * The string key for the tag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKey() {
        return this.jsiiGet("key", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagProps getProps() {
        return this.jsiiGet("props", software.amazon.awscdk.core.TagProps.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.RemoveTag}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.RemoveTag> {
        /**
         * @return a new instance of {@link Builder}.
         * @param key This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String key) {
            return new Builder(key);
        }

        private final java.lang.String key;
        private software.amazon.awscdk.core.TagProps.Builder props;

        private Builder(final java.lang.String key) {
            this.key = key;
        }

        /**
         * Whether the tag should be applied to instances in an AutoScalingGroup.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param applyToLaunchedInstances Whether the tag should be applied to instances in an AutoScalingGroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyToLaunchedInstances(final java.lang.Boolean applyToLaunchedInstances) {
            this.props().applyToLaunchedInstances(applyToLaunchedInstances);
            return this;
        }

        /**
         * An array of Resource Types that will not receive this tag.
         * <p>
         * An empty array will allow this tag to be applied to all resources. A
         * non-empty array will apply this tag only if the Resource type is not in
         * this array.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param excludeResourceTypes An array of Resource Types that will not receive this tag. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTypes(final java.util.List<java.lang.String> excludeResourceTypes) {
            this.props().excludeResourceTypes(excludeResourceTypes);
            return this;
        }

        /**
         * An array of Resource Types that will receive this tag.
         * <p>
         * An empty array will match any Resource. A non-empty array will apply this
         * tag only to Resource types that are included in this array.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param includeResourceTypes An array of Resource Types that will receive this tag. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeResourceTypes(final java.util.List<java.lang.String> includeResourceTypes) {
            this.props().includeResourceTypes(includeResourceTypes);
            return this;
        }

        /**
         * Priority of the tag operation.
         * <p>
         * Higher or equal priority tags will take precedence.
         * <p>
         * Setting priority will enable the user to control tags when they need to not
         * follow the default precedence pattern of last applied and closest to the
         * construct in the tree.
         * <p>
         * Default: Default priorities:
         * - 100 for {@link SetTag}
         * - 200 for {@link RemoveTag}
         * - 50 for tags added directly to CloudFormation resources
         * <p>
         * @return {@code this}
         * @param priority Priority of the tag operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props().priority(priority);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.RemoveTag}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.RemoveTag build() {
            return new software.amazon.awscdk.core.RemoveTag(
                this.key,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.TagProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.TagProps.Builder();
            }
            return this.props;
        }
    }
}
