package software.amazon.awscdk.core;

/**
 * Traffic routing configuration settings.
 * <p>
 * The type of the {&#64;link CfnCodeDeployBlueGreenHookProps.trafficRoutingConfig} property.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-13T06:02:40.357Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnTrafficRoutingConfig")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficRoutingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrafficRoutingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of traffic shifting used by the blue-green deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnTrafficRoutingType getType();

    /**
     * The configuration for traffic routing when {@link type} is {@link CfnTrafficRoutingType.TIME_BASED_CANARY}.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary getTimeBasedCanary() {
        return null;
    }

    /**
     * The configuration for traffic routing when {@link type} is {@link CfnTrafficRoutingType.TIME_BASED_LINEAR}.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear getTimeBasedLinear() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrafficRoutingConfig> {
        private software.amazon.awscdk.core.CfnTrafficRoutingType type;
        private software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary timeBasedCanary;
        private software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear timeBasedLinear;

        /**
         * Sets the value of {@link CfnTrafficRoutingConfig#getType}
         * @param type The type of traffic shifting used by the blue-green deployment configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.core.CfnTrafficRoutingType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRoutingConfig#getTimeBasedCanary}
         * @param timeBasedCanary The configuration for traffic routing when {@link type} is {@link CfnTrafficRoutingType.TIME_BASED_CANARY}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedCanary(software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary timeBasedCanary) {
            this.timeBasedCanary = timeBasedCanary;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRoutingConfig#getTimeBasedLinear}
         * @param timeBasedLinear The configuration for traffic routing when {@link type} is {@link CfnTrafficRoutingType.TIME_BASED_LINEAR}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedLinear(software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear timeBasedLinear) {
            this.timeBasedLinear = timeBasedLinear;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficRoutingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrafficRoutingConfig build() {
            return new Jsii$Proxy(type, timeBasedCanary, timeBasedLinear);
        }
    }

    /**
     * An implementation for {@link CfnTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficRoutingConfig {
        private final software.amazon.awscdk.core.CfnTrafficRoutingType type;
        private final software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary timeBasedCanary;
        private final software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear timeBasedLinear;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = this.jsiiGet("type", software.amazon.awscdk.core.CfnTrafficRoutingType.class);
            this.timeBasedCanary = this.jsiiGet("timeBasedCanary", software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary.class);
            this.timeBasedLinear = this.jsiiGet("timeBasedLinear", software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.core.CfnTrafficRoutingType type, final software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary timeBasedCanary, final software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear timeBasedLinear) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.timeBasedCanary = timeBasedCanary;
            this.timeBasedLinear = timeBasedLinear;
        }

        @Override
        public software.amazon.awscdk.core.CfnTrafficRoutingType getType() {
            return this.type;
        }

        @Override
        public software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedCanary getTimeBasedCanary() {
            return this.timeBasedCanary;
        }

        @Override
        public software.amazon.awscdk.core.CfnTrafficRoutingTimeBasedLinear getTimeBasedLinear() {
            return this.timeBasedLinear;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getTimeBasedCanary() != null) {
                data.set("timeBasedCanary", om.valueToTree(this.getTimeBasedCanary()));
            }
            if (this.getTimeBasedLinear() != null) {
                data.set("timeBasedLinear", om.valueToTree(this.getTimeBasedLinear()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnTrafficRoutingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficRoutingConfig.Jsii$Proxy that = (CfnTrafficRoutingConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.timeBasedCanary != null ? !this.timeBasedCanary.equals(that.timeBasedCanary) : that.timeBasedCanary != null) return false;
            return this.timeBasedLinear != null ? this.timeBasedLinear.equals(that.timeBasedLinear) : that.timeBasedLinear == null;
        }

        @Override
        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.timeBasedCanary != null ? this.timeBasedCanary.hashCode() : 0);
            result = 31 * result + (this.timeBasedLinear != null ? this.timeBasedLinear.hashCode() : 0);
            return result;
        }
    }
}
