package software.amazon.awscdk.core;

/**
 * A construct which represents an entire CDK app. This construct is normally the root of the construct tree.
 * <p>
 * You would normally define an <code>App</code> instance in your program's entrypoint,
 * then define constructs where the app is used as the parent scope.
 * <p>
 * After all the child constructs are defined within the app, you should call
 * <code>app.synth()</code> which will emit a "cloud assembly" from this app into the
 * directory specified by <code>outdir</code>. Cloud assemblies includes artifacts such as
 * CloudFormation templates and assets that are needed to deploy this app into
 * the AWS cloud.
 * <p>
 * @see https://docs.aws.amazon.com/cdk/latest/guide/apps.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-13T06:02:40.331Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.App")
public class App extends software.amazon.awscdk.core.Stage {

    protected App(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected App(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initializes a CDK application.
     * <p>
     * @param props initialization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.AppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Initializes a CDK application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Checks if an object is an instance of the `App` class.
     * <p>
     * @return `true` if `obj` is an `App`.
     * @param obj The object to evaluate. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isApp(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.App.class, "isApp", java.lang.Boolean.class, new Object[] { obj });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.App}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.App> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.core.AppProps.Builder props;

        private Builder() {
        }

        /**
         * Automatically call `synth()` before the program exits.
         * <p>
         * If you set this, you don't have to call <code>synth()</code> explicitly. Note that
         * this feature is only available for certain programming languages, and
         * calling <code>synth()</code> is still recommended.
         * <p>
         * Default: true if running via CDK CLI (`CDK_OUTDIR` is set), `false`
         * otherwise
         * <p>
         * @return {@code this}
         * @param autoSynth Automatically call `synth()` before the program exits. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSynth(final java.lang.Boolean autoSynth) {
            this.props().autoSynth(autoSynth);
            return this;
        }

        /**
         * Additional context values for the application.
         * <p>
         * Context set by the CLI or the <code>context</code> key in <code>cdk.json</code> has precedence.
         * <p>
         * Context can be read from any construct using <code>node.getContext(key)</code>.
         * <p>
         * Default: - no additional context
         * <p>
         * @return {@code this}
         * @param context Additional context values for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(final java.util.Map<java.lang.String, java.lang.Object> context) {
            this.props().context(context);
            return this;
        }

        /**
         * The output directory into which to emit synthesized artifacts.
         * <p>
         * Default: - If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.
         *   If `CDK_OUTDIR` is not defined, uses a temp directory.
         * <p>
         * @return {@code this}
         * @param outdir The output directory into which to emit synthesized artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(final java.lang.String outdir) {
            this.props().outdir(outdir);
            return this;
        }

        /**
         * Include runtime versioning information in cloud assembly manifest.
         * <p>
         * Default: true runtime info is included unless `aws:cdk:disable-runtime-info` is set in the context.
         * <p>
         * @return {@code this}
         * @param runtimeInfo Include runtime versioning information in cloud assembly manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeInfo(final java.lang.Boolean runtimeInfo) {
            this.props().runtimeInfo(runtimeInfo);
            return this;
        }

        /**
         * Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.
         * <p>
         * Default: true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.
         * <p>
         * @return {@code this}
         * @param stackTraces Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTraces(final java.lang.Boolean stackTraces) {
            this.props().stackTraces(stackTraces);
            return this;
        }

        /**
         * Include construct tree metadata as part of the Cloud Assembly.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param treeMetadata Include construct tree metadata as part of the Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treeMetadata(final java.lang.Boolean treeMetadata) {
            this.props().treeMetadata(treeMetadata);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.App}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.App build() {
            return new software.amazon.awscdk.core.App(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.AppProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.AppProps.Builder();
            }
            return this.props;
        }
    }
}
