package software.amazon.awscdk.core;

/**
 * Interface for values that can be resolvable later.
 * <p>
 * Tokens are special objects that participate in synthesis.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-03T17:04:06.311Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.IResolvable")
@software.amazon.jsii.Jsii.Proxy(IResolvable.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IResolvable extends software.amazon.jsii.JsiiSerializable {

    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * <p>
     * If this returns an empty array the stack will not be attached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack();

    /**
     * Produce the Token's value at resolution time.
     * <p>
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext context);

    /**
     * Return a string representation of this resolvable object.
     * <p>
     * Returns a reversible string representation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String toString();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IResolvable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The creation stack of this resolvable which will be appended to errors thrown during resolution.
         * <p>
         * If this returns an empty array the stack will not be attached.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
            return java.util.Collections.unmodifiableList(this.jsiiGet("creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * Produce the Token's value at resolution time.
         * <p>
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext context) {
            return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
        }

        /**
         * Return a string representation of this resolvable object.
         * <p>
         * Returns a reversible string representation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.String toString() {
            return this.jsiiCall("toString", java.lang.String.class);
        }
    }
}
