package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-28T10:19:06.287Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Arn")
public class Arn extends software.amazon.jsii.JsiiObject {

    protected Arn(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Arn(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates an ARN from components.
     * <p>
     * If <code>partition</code>, <code>region</code> or <code>account</code> are not specified, the stack's
     * partition, region and account will be used.
     * <p>
     * If any component is the empty string, an empty string will be inserted
     * into the generated ARN at the location that component corresponds to.
     * <p>
     * The ARN will be formatted as follows:
     * <p>
     * arn:{partition}:{service}:{region}:{account}:{resource}{sep}{resource-name}
     * <p>
     * The required ARN pieces that are omitted will be taken from the stack that
     * the 'scope' is attached to. If all ARN pieces are supplied, the supplied scope
     * can be 'undefined'.
     * <p>
     * @param components This parameter is required.
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String format(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents components, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "format", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(components, "components is required"), java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Given an ARN, parses it and returns components.
     * <p>
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (<code>sep</code>) will be set to '/' if the 6th component includes a '/',
     * in which case, <code>resource</code> will be set to the value before the '/' and
     * <code>resourceName</code> will be the rest. In case there is no '/', <code>resource</code> will
     * be set to the 6th components and <code>resourceName</code> will be set to the rest
     * of the string.
     * <p>
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting <code>ArnComponents</code> object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * <p>
     * <blockquote><pre>
     * arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * </pre></blockquote>
     * <p>
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     * @param hasName Whether there is a name component in the ARN at all.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parse(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable java.lang.String sepIfToken, final @org.jetbrains.annotations.Nullable java.lang.Boolean hasName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName });
    }

    /**
     * Given an ARN, parses it and returns components.
     * <p>
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (<code>sep</code>) will be set to '/' if the 6th component includes a '/',
     * in which case, <code>resource</code> will be set to the value before the '/' and
     * <code>resourceName</code> will be the rest. In case there is no '/', <code>resource</code> will
     * be set to the 6th components and <code>resourceName</code> will be set to the rest
     * of the string.
     * <p>
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting <code>ArnComponents</code> object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * <p>
     * <blockquote><pre>
     * arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * </pre></blockquote>
     * <p>
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parse(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable java.lang.String sepIfToken) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken });
    }

    /**
     * Given an ARN, parses it and returns components.
     * <p>
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (<code>sep</code>) will be set to '/' if the 6th component includes a '/',
     * in which case, <code>resource</code> will be set to the value before the '/' and
     * <code>resourceName</code> will be the rest. In case there is no '/', <code>resource</code> will
     * be set to the 6th components and <code>resourceName</code> will be set to the rest
     * of the string.
     * <p>
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting <code>ArnComponents</code> object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * <p>
     * <blockquote><pre>
     * arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * </pre></blockquote>
     * <p>
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parse(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }
}
