package software.amazon.awscdk.core;

/**
 * Includes API for attaching annotations such as warning messages to constructs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-27T08:37:30.501Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Annotations")
public class Annotations extends software.amazon.jsii.JsiiObject {

    protected Annotations(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Annotations(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns the annotations API for a construct scope.
     * <p>
     * @param scope The scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Annotations of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Annotations.class, "of", software.amazon.awscdk.core.Annotations.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Adds a deprecation warning for a specific API.
     * <p>
     * Deprecations will be added only once per construct as a warning and will be
     * deduplicated based on the <code>api</code>.
     * <p>
     * If the environment variable <code>CDK_BLOCK_DEPRECATIONS</code> is set, this method
     * will throw an error instead with the deprecation message.
     * <p>
     * @param api The API being deprecated in the format `module.Class.property` (e.g. `@aws-cdk/core.Construct.node`). This parameter is required.
     * @param message The deprecation message to display, with information about alternatives. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeprecation(final @org.jetbrains.annotations.NotNull java.lang.String api, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        this.jsiiCall("addDeprecation", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(api, "api is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * <p>
     * The toolkit will fail synthesis when errors are reported.
     * <p>
     * @param message The error message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addError(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        this.jsiiCall("addError", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds an info metadata entry to this construct.
     * <p>
     * The CLI will display the info message when apps are synthesized.
     * <p>
     * @param message The info message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addInfo(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        this.jsiiCall("addInfo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds a warning metadata entry to this construct.
     * <p>
     * The CLI will display the warning when an app is synthesized, or fail if run
     * in --strict mode.
     * <p>
     * @param message The warning message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addWarning(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        this.jsiiCall("addWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }
}
