package software.amazon.awscdk.core;

/**
 * Trait for IDependable.
 * <p>
 * Traits are interfaces that are privately implemented by objects. Instead of
 * showing up in the public interface of a class, they need to be queried
 * explicitly. This is used to implement certain framework features that are
 * not intended to be used by Construct consumers, and so should be hidden
 * from accidental use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>{@code
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Usage
 * var roots = DependableTrait.get(construct).getDependencyRoots();
 * // Definition
 * DependableTrait.implement(construct, Map.of(get dependencyRoots() { return []; }));}</pre></blockquote>
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:24:59.207Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DependableTrait")
public abstract class DependableTrait extends software.amazon.jsii.JsiiObject {

    protected DependableTrait(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DependableTrait(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected DependableTrait() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Return the matching DependableTrait for the given class instance.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DependableTrait get(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DependableTrait.class, "get", software.amazon.awscdk.core.DependableTrait.class, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Register `instance` to have the given DependableTrait.
     * <p>
     * Should be called in the class constructor.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param instance This parameter is required.
     * @param trait This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static void implement(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable instance, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DependableTrait trait) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DependableTrait.class, "implement", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required"), java.util.Objects.requireNonNull(trait, "trait is required") });
    }

    /**
     * The set of constructs that form the root of this dependable.
     * <p>
     * All resources under all returned constructs are included in the ordering
     * dependency.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.IConstruct> getDependencyRoots();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.core.DependableTrait {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The set of constructs that form the root of this dependable.
         * <p>
         * All resources under all returned constructs are included in the ordering
         * dependency.
         * <p>
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.IConstruct> getDependencyRoots() {
            return java.util.Collections.unmodifiableList(this.jsiiGet("dependencyRoots", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IConstruct.class))));
        }
    }
}
