package software.amazon.awscdk.core;

/**
 * Initialization properties for `AssetStaging`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:24:59.174Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.AssetStagingProps")
@software.amazon.jsii.Jsii.Proxy(AssetStagingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetStagingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.FingerprintOptions, software.amazon.awscdk.core.AssetOptions {

    /**
     * The source file or directory to copy from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourcePath();

    /**
     * @return a {@link Builder} of {@link AssetStagingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetStagingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetStagingProps> {
        private java.lang.String sourcePath;
        private java.lang.String extraHash;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.core.SymlinkFollowMode follow;
        private java.lang.String assetHash;
        private software.amazon.awscdk.core.AssetHashType assetHashType;
        private software.amazon.awscdk.core.BundlingOptions bundling;

        /**
         * Sets the value of {@link AssetStagingProps#getSourcePath}
         * @param sourcePath The source file or directory to copy from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcePath(java.lang.String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getExtraHash}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(java.lang.String extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getFollow}
         * @param follow A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder follow(software.amazon.awscdk.core.SymlinkFollowMode follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getAssetHashType}
         * @param assetHashType Specifies the type of hash to calculate for this asset.
         *                      If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         *                      <code>AssetHashType.CUSTOM</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(software.amazon.awscdk.core.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getBundling}
         * @param bundling Bundle the asset by executing a command in a Docker container.
         *                 The asset path will be mounted at <code>/asset-input</code>. The Docker
         *                 container is responsible for putting content at <code>/asset-output</code>.
         *                 The content at <code>/asset-output</code> will be zipped and used as the
         *                 final asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundling(software.amazon.awscdk.core.BundlingOptions bundling) {
            this.bundling = bundling;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetStagingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetStagingProps build() {
            return new Jsii$Proxy(sourcePath, extraHash, exclude, follow, assetHash, assetHashType, bundling);
        }
    }

    /**
     * An implementation for {@link AssetStagingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetStagingProps {
        private final java.lang.String sourcePath;
        private final java.lang.String extraHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.core.SymlinkFollowMode follow;
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.core.AssetHashType assetHashType;
        private final software.amazon.awscdk.core.BundlingOptions bundling;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourcePath = this.jsiiGet("sourcePath", java.lang.String.class);
            this.extraHash = this.jsiiGet("extraHash", java.lang.String.class);
            this.exclude = this.jsiiGet("exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.follow = this.jsiiGet("follow", software.amazon.awscdk.core.SymlinkFollowMode.class);
            this.assetHash = this.jsiiGet("assetHash", java.lang.String.class);
            this.assetHashType = this.jsiiGet("assetHashType", software.amazon.awscdk.core.AssetHashType.class);
            this.bundling = this.jsiiGet("bundling", software.amazon.awscdk.core.BundlingOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String sourcePath, final java.lang.String extraHash, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.core.SymlinkFollowMode follow, final java.lang.String assetHash, final software.amazon.awscdk.core.AssetHashType assetHashType, final software.amazon.awscdk.core.BundlingOptions bundling) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourcePath = java.util.Objects.requireNonNull(sourcePath, "sourcePath is required");
            this.extraHash = extraHash;
            this.exclude = exclude;
            this.follow = follow;
            this.assetHash = assetHash;
            this.assetHashType = assetHashType;
            this.bundling = bundling;
        }

        @Override
        public java.lang.String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public java.lang.String getExtraHash() {
            return this.extraHash;
        }

        @Override
        public java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public software.amazon.awscdk.core.SymlinkFollowMode getFollow() {
            return this.follow;
        }

        @Override
        public java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public software.amazon.awscdk.core.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public software.amazon.awscdk.core.BundlingOptions getBundling() {
            return this.bundling;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourcePath", om.valueToTree(this.getSourcePath()));
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollow() != null) {
                data.set("follow", om.valueToTree(this.getFollow()));
            }
            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBundling() != null) {
                data.set("bundling", om.valueToTree(this.getBundling()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.AssetStagingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetStagingProps.Jsii$Proxy that = (AssetStagingProps.Jsii$Proxy) o;

            if (!sourcePath.equals(that.sourcePath)) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.follow != null ? !this.follow.equals(that.follow) : that.follow != null) return false;
            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            return this.bundling != null ? this.bundling.equals(that.bundling) : that.bundling == null;
        }

        @Override
        public int hashCode() {
            int result = this.sourcePath.hashCode();
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.follow != null ? this.follow.hashCode() : 0);
            result = 31 * result + (this.assetHash != null ? this.assetHash.hashCode() : 0);
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.bundling != null ? this.bundling.hashCode() : 0);
            return result;
        }
    }
}
