package software.amazon.awscdk.core;

/**
 * Represents a reference that originates from a specific construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:16:43.974Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OutgoingReference extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Reference getReference();

    /**
     * The originating construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.IConstruct getSource();

    /**
     * @return a {@link Builder} of {@link OutgoingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link OutgoingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.core.Reference reference;
        private software.amazon.awscdk.core.IConstruct source;

        /**
         * Sets the value of Reference
         * @param reference The reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reference(software.amazon.awscdk.core.Reference reference) {
            this.reference = reference;
            return this;
        }

        /**
         * Sets the value of Source
         * @param source The originating construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.core.IConstruct source) {
            this.source = source;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OutgoingReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public OutgoingReference build() {
            return new Jsii$Proxy(reference, source);
        }

    }

    /**
     * An implementation for {@link OutgoingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutgoingReference {
        private final software.amazon.awscdk.core.Reference reference;
        private final software.amazon.awscdk.core.IConstruct source;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.reference = this.jsiiGet("reference", software.amazon.awscdk.core.Reference.class);
            this.source = this.jsiiGet("source", software.amazon.awscdk.core.IConstruct.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.core.Reference reference, software.amazon.awscdk.core.IConstruct source) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.reference = java.util.Objects.requireNonNull(reference, "reference is required");
            this.source = java.util.Objects.requireNonNull(source, "source is required");
        }

        @Override
        public software.amazon.awscdk.core.Reference getReference() {
            return this.reference;
        }

        @Override
        public software.amazon.awscdk.core.IConstruct getSource() {
            return this.source;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("reference", om.valueToTree(this.getReference()));
            obj.set("source", om.valueToTree(this.getSource()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OutgoingReference.Jsii$Proxy that = (OutgoingReference.Jsii$Proxy) o;

            if (!reference.equals(that.reference)) return false;
            return this.source.equals(that.source);
        }

        @Override
        public int hashCode() {
            int result = this.reference.hashCode();
            result = 31 * result + (this.source.hashCode());
            return result;
        }

    }
}
