package software.amazon.awscdk.core;

/**
 * For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-31T23:31:21.802Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnResourceAutoScalingCreationPolicy")
@software.amazon.jsii.Jsii.Proxy(CfnResourceAutoScalingCreationPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceAutoScalingCreationPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
     * <p>
     * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
     * For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
     * If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
     * instance wasn't created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceAutoScalingCreationPolicy> {
        private java.lang.Number minSuccessfulInstancesPercent;

        /**
         * Sets the value of {@link CfnResourceAutoScalingCreationPolicy#getMinSuccessfulInstancesPercent}
         * @param minSuccessfulInstancesPercent Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
         *                                      You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
         *                                      For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
         *                                      If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
         *                                      instance wasn't created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSuccessfulInstancesPercent(java.lang.Number minSuccessfulInstancesPercent) {
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceAutoScalingCreationPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceAutoScalingCreationPolicy build() {
            return new Jsii$Proxy(minSuccessfulInstancesPercent);
        }
    }

    /**
     * An implementation for {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceAutoScalingCreationPolicy {
        private final java.lang.Number minSuccessfulInstancesPercent;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minSuccessfulInstancesPercent = this.jsiiGet("minSuccessfulInstancesPercent", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number minSuccessfulInstancesPercent) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
        }

        @Override
        public java.lang.Number getMinSuccessfulInstancesPercent() {
            return this.minSuccessfulInstancesPercent;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMinSuccessfulInstancesPercent() != null) {
                data.set("minSuccessfulInstancesPercent", om.valueToTree(this.getMinSuccessfulInstancesPercent()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnResourceAutoScalingCreationPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceAutoScalingCreationPolicy.Jsii$Proxy that = (CfnResourceAutoScalingCreationPolicy.Jsii$Proxy) o;

            return this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.equals(that.minSuccessfulInstancesPercent) : that.minSuccessfulInstancesPercent == null;
        }

        @Override
        public int hashCode() {
            int result = this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.hashCode() : 0;
            return result;
        }
    }
}
