package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-31T23:31:21.799Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnOutputProps")
@software.amazon.jsii.Jsii.Proxy(CfnOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value of the property returned by the aws cloudformation describe-stacks command.
     * <p>
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * A condition to associate with this output value.
     * <p>
     * If the condition evaluates
     * to <code>false</code>, this output value will not be included in the stack.
     * <p>
     * Default: - No condition is associated with the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCondition getCondition() {
        return null;
    }

    /**
     * A String type that describes the output value.
     * <p>
     * The description can be a maximum of 4 K in length.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name used to export the value of this output across stacks.
     * <p>
     * To import the value from another stack, use <code>Fn.importValue(exportName)</code>.
     * <p>
     * Default: - the output is not exported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExportName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOutputProps> {
        private java.lang.String value;
        private software.amazon.awscdk.core.CfnCondition condition;
        private java.lang.String description;
        private java.lang.String exportName;

        /**
         * Sets the value of {@link CfnOutputProps#getValue}
         * @param value The value of the property returned by the aws cloudformation describe-stacks command. This parameter is required.
         *              The value of an output can include literals, parameter references, pseudo-parameters,
         *              a mapping value, or intrinsic functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getCondition}
         * @param condition A condition to associate with this output value.
         *                  If the condition evaluates
         *                  to <code>false</code>, this output value will not be included in the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.core.CfnCondition condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getDescription}
         * @param description A String type that describes the output value.
         *                    The description can be a maximum of 4 K in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnOutputProps#getExportName}
         * @param exportName The name used to export the value of this output across stacks.
         *                   To import the value from another stack, use <code>Fn.importValue(exportName)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportName(java.lang.String exportName) {
            this.exportName = exportName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOutputProps build() {
            return new Jsii$Proxy(value, condition, description, exportName);
        }
    }

    /**
     * An implementation for {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOutputProps {
        private final java.lang.String value;
        private final software.amazon.awscdk.core.CfnCondition condition;
        private final java.lang.String description;
        private final java.lang.String exportName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.value = this.jsiiGet("value", java.lang.String.class);
            this.condition = this.jsiiGet("condition", software.amazon.awscdk.core.CfnCondition.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.exportName = this.jsiiGet("exportName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String value, final software.amazon.awscdk.core.CfnCondition condition, final java.lang.String description, final java.lang.String exportName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.value = java.util.Objects.requireNonNull(value, "value is required");
            this.condition = condition;
            this.description = description;
            this.exportName = exportName;
        }

        @Override
        public java.lang.String getValue() {
            return this.value;
        }

        @Override
        public software.amazon.awscdk.core.CfnCondition getCondition() {
            return this.condition;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getExportName() {
            return this.exportName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("value", om.valueToTree(this.getValue()));
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExportName() != null) {
                data.set("exportName", om.valueToTree(this.getExportName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOutputProps.Jsii$Proxy that = (CfnOutputProps.Jsii$Proxy) o;

            if (!value.equals(that.value)) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.exportName != null ? this.exportName.equals(that.exportName) : that.exportName == null;
        }

        @Override
        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.exportName != null ? this.exportName.hashCode() : 0);
            return result;
        }
    }
}
