package software.amazon.awscdk.core;

/**
 * Construction properties for {@link Resource}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:14.864Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.ResourceProps")
@software.amazon.jsii.Jsii.Proxy(ResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value passed in by users to the physical name prop of the resource.
     * <p>
     * <ul>
     * <li><code>undefined</code> implies that a physical name will be allocated by
     * CloudFormation during deployment.</li>
     * <li>a concrete value implies a specific physical name</li>
     * <li><code>PhysicalName.GENERATE_IF_NEEDED</code> is a marker that indicates that a physical will only be generated
     * by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.</li>
     * </ul>
     * <p>
     * Default: - The physical name will be allocated by CloudFormation at deployment time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPhysicalName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceProps> {
        private java.lang.String physicalName;

        /**
         * Sets the value of {@link ResourceProps#getPhysicalName}
         * @param physicalName The value passed in by users to the physical name prop of the resource.
         *                     <ul>
         *                     <li><code>undefined</code> implies that a physical name will be allocated by
         *                     CloudFormation during deployment.</li>
         *                     <li>a concrete value implies a specific physical name</li>
         *                     <li><code>PhysicalName.GENERATE_IF_NEEDED</code> is a marker that indicates that a physical will only be generated
         *                     by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalName(java.lang.String physicalName) {
            this.physicalName = physicalName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceProps build() {
            return new Jsii$Proxy(physicalName);
        }
    }

    /**
     * An implementation for {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceProps {
        private final java.lang.String physicalName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.physicalName = this.jsiiGet("physicalName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String physicalName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.physicalName = physicalName;
        }

        @Override
        public java.lang.String getPhysicalName() {
            return this.physicalName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPhysicalName() != null) {
                data.set("physicalName", om.valueToTree(this.getPhysicalName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.ResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceProps.Jsii$Proxy that = (ResourceProps.Jsii$Proxy) o;

            return this.physicalName != null ? this.physicalName.equals(that.physicalName) : that.physicalName == null;
        }

        @Override
        public int hashCode() {
            int result = this.physicalName != null ? this.physicalName.hashCode() : 0;
            return result;
        }
    }
}
