package software.amazon.awscdk.core;

/**
 * Represents a length of time.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-20T10:46:23.455Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Duration")
public class Duration extends software.amazon.jsii.JsiiObject {

    protected Duration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Duration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a Duration representing an amount of days.
     * <p>
     * @return a new `Duration` representing `amount` Days.
     * @param amount the amount of Days the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration days(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "days", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of hours.
     * <p>
     * @return a new `Duration` representing `amount` Hours.
     * @param amount the amount of Hours the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration hours(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "hours", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of milliseconds.
     * <p>
     * @return a new `Duration` representing `amount` ms.
     * @param amount the amount of Milliseconds the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration millis(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "millis", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of minutes.
     * <p>
     * @return a new `Duration` representing `amount` Minutes.
     * @param amount the amount of Minutes the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration minutes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "minutes", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Parse a period formatted according to the ISO 8601 standard.
     * <p>
     * @return the parsed `Duration`.
     * @see https://www.iso.org/fr/standard/70907.html
     * @param duration an ISO-formtted duration to be parsed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration parse(final @org.jetbrains.annotations.NotNull java.lang.String duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "parse", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Create a Duration representing an amount of seconds.
     * <p>
     * @return a new `Duration` representing `amount` Seconds.
     * @param amount the amount of Seconds the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration seconds(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "seconds", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Add two Durations together.
     * <p>
     * @param rhs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration plus(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration rhs) {
        return this.jsiiCall("plus", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(rhs, "rhs is required") });
    }

    /**
     * Return the total number of days in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Days.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toDays(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toDays", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return the total number of days in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toDays() {
        return this.jsiiCall("toDays", java.lang.Number.class);
    }

    /**
     * Return the total number of hours in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Hours.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toHours(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toHours", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return the total number of hours in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toHours() {
        return this.jsiiCall("toHours", java.lang.Number.class);
    }

    /**
     * Turn this duration into a human-readable string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toHumanString() {
        return this.jsiiCall("toHumanString", java.lang.String.class);
    }

    /**
     * Return an ISO 8601 representation of this period.
     * <p>
     * @return a string starting with 'PT' describing the period
     * @see https://www.iso.org/fr/standard/70907.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toIsoString() {
        return this.jsiiCall("toIsoString", java.lang.String.class);
    }

    /**
     * Return an ISO 8601 representation of this period.
     * <p>
     * @return a string starting with 'PT' describing the period
     * @see https://www.iso.org/fr/standard/70907.html
     * @deprecated Use `toIsoString()` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String toISOString() {
        return this.jsiiCall("toISOString", java.lang.String.class);
    }

    /**
     * Return the total number of milliseconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Milliseconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toMilliseconds", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return the total number of milliseconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMilliseconds() {
        return this.jsiiCall("toMilliseconds", java.lang.Number.class);
    }

    /**
     * Return the total number of minutes in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Minutes.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMinutes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toMinutes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return the total number of minutes in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMinutes() {
        return this.jsiiCall("toMinutes", java.lang.Number.class);
    }

    /**
     * Return the total number of seconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Seconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toSeconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toSeconds", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return the total number of seconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toSeconds() {
        return this.jsiiCall("toSeconds", java.lang.Number.class);
    }

    /**
     * Returns a string representation of this `Duration` that is also a Token that cannot be successfully resolved.
     * <p>
     * This
     * protects users against inadvertently stringifying a <code>Duration</code> object, when they should have called one of the
     * <code>to*</code> methods instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }
}
