/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.ArnComponents;
import software.amazon.awscdk.core.CfnElement;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.DockerImageAssetLocation;
import software.amazon.awscdk.core.DockerImageAssetSource;
import software.amazon.awscdk.core.Environment;
import software.amazon.awscdk.core.FileAssetLocation;
import software.amazon.awscdk.core.FileAssetSource;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.IStackSynthesizer;
import software.amazon.awscdk.core.ISynthesisSession;
import software.amazon.awscdk.core.ITaggable;
import software.amazon.awscdk.core.ITemplateOptions;
import software.amazon.awscdk.core.Reference;
import software.amazon.awscdk.core.StackProps;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.cxapi.MissingContext;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.Stack")
public class Stack
extends Construct
implements ITaggable {
    protected Stack(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stack(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Stack(@Nullable Construct scope, @Nullable String id, @Nullable StackProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope, id, props});
    }

    public Stack(@Nullable Construct scope, @Nullable String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope, id});
    }

    public Stack(@Nullable Construct scope) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope});
    }

    public Stack() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static Boolean isStack(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Stack.class, (String)"isStack", Boolean.class, (Object[])new Object[]{x});
    }

    @NotNull
    public static Stack of(@NotNull IConstruct construct) {
        return (Stack)JsiiObject.jsiiStaticCall(Stack.class, (String)"of", Stack.class, (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    public void addDependency(@NotNull Stack target, @Nullable String reason) {
        this.jsiiCall("addDependency", NativeType.VOID, new Object[]{Objects.requireNonNull(target, "target is required"), reason});
    }

    public void addDependency(@NotNull Stack target) {
        this.jsiiCall("addDependency", NativeType.VOID, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @Deprecated
    @NotNull
    public DockerImageAssetLocation addDockerImageAsset(@NotNull DockerImageAssetSource asset) {
        return (DockerImageAssetLocation)this.jsiiCall("addDockerImageAsset", DockerImageAssetLocation.class, new Object[]{Objects.requireNonNull(asset, "asset is required")});
    }

    @Deprecated
    @NotNull
    public FileAssetLocation addFileAsset(@NotNull FileAssetSource asset) {
        return (FileAssetLocation)this.jsiiCall("addFileAsset", FileAssetLocation.class, new Object[]{Objects.requireNonNull(asset, "asset is required")});
    }

    public void addTransform(@NotNull String transform) {
        this.jsiiCall("addTransform", NativeType.VOID, new Object[]{Objects.requireNonNull(transform, "transform is required")});
    }

    @NotNull
    protected String allocateLogicalId(@NotNull CfnElement cfnElement) {
        return (String)this.jsiiCall("allocateLogicalId", String.class, new Object[]{Objects.requireNonNull(cfnElement, "cfnElement is required")});
    }

    @NotNull
    public String formatArn(@NotNull ArnComponents components) {
        return (String)this.jsiiCall("formatArn", String.class, new Object[]{Objects.requireNonNull(components, "components is required")});
    }

    @NotNull
    public String getLogicalId(@NotNull CfnElement element) {
        return (String)this.jsiiCall("getLogicalId", String.class, new Object[]{Objects.requireNonNull(element, "element is required")});
    }

    @NotNull
    public ArnComponents parseArn(@NotNull String arn, @Nullable String sepIfToken, @Nullable Boolean hasName) {
        return (ArnComponents)this.jsiiCall("parseArn", ArnComponents.class, new Object[]{Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName});
    }

    @NotNull
    public ArnComponents parseArn(@NotNull String arn, @Nullable String sepIfToken) {
        return (ArnComponents)this.jsiiCall("parseArn", ArnComponents.class, new Object[]{Objects.requireNonNull(arn, "arn is required"), sepIfToken});
    }

    @NotNull
    public ArnComponents parseArn(@NotNull String arn) {
        return (ArnComponents)this.jsiiCall("parseArn", ArnComponents.class, new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    @Deprecated
    @NotNull
    protected IResolvable prepareCrossReference(@NotNull Stack _sourceStack, @NotNull Reference reference) {
        return (IResolvable)this.jsiiCall("prepareCrossReference", IResolvable.class, new Object[]{Objects.requireNonNull(_sourceStack, "_sourceStack is required"), Objects.requireNonNull(reference, "reference is required")});
    }

    public void renameLogicalId(@NotNull String oldId, @NotNull String newId) {
        this.jsiiCall("renameLogicalId", NativeType.VOID, new Object[]{Objects.requireNonNull(oldId, "oldId is required"), Objects.requireNonNull(newId, "newId is required")});
    }

    public void reportMissingContext(@NotNull MissingContext report) {
        this.jsiiCall("reportMissingContext", NativeType.VOID, new Object[]{Objects.requireNonNull(report, "report is required")});
    }

    @NotNull
    public Object resolve(@NotNull Object obj) {
        return this.jsiiCall("resolve", Object.class, new Object[]{obj});
    }

    @Override
    protected void synthesize(@NotNull ISynthesisSession session) {
        this.jsiiCall("synthesize", NativeType.VOID, new Object[]{Objects.requireNonNull(session, "session is required")});
    }

    @NotNull
    public String toJsonString(@NotNull Object obj, @Nullable Number space) {
        return (String)this.jsiiCall("toJsonString", String.class, new Object[]{obj, space});
    }

    @NotNull
    public String toJsonString(@NotNull Object obj) {
        return (String)this.jsiiCall("toJsonString", String.class, new Object[]{obj});
    }

    @NotNull
    public String getAccount() {
        return (String)this.jsiiGet("account", String.class);
    }

    @NotNull
    public String getArtifactId() {
        return (String)this.jsiiGet("artifactId", String.class);
    }

    @NotNull
    public List<String> getAvailabilityZones() {
        return Collections.unmodifiableList((List)this.jsiiGet("availabilityZones", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<Stack> getDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("dependencies", NativeType.listOf((NativeType)NativeType.forClass(Stack.class))));
    }

    @NotNull
    public String getEnvironment() {
        return (String)this.jsiiGet("environment", String.class);
    }

    @NotNull
    public Boolean getNested() {
        return (Boolean)this.jsiiGet("nested", Boolean.class);
    }

    @NotNull
    public List<String> getNotificationArns() {
        return Collections.unmodifiableList((List)this.jsiiGet("notificationArns", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getPartition() {
        return (String)this.jsiiGet("partition", String.class);
    }

    @NotNull
    public String getRegion() {
        return (String)this.jsiiGet("region", String.class);
    }

    @NotNull
    public String getStackId() {
        return (String)this.jsiiGet("stackId", String.class);
    }

    @NotNull
    public String getStackName() {
        return (String)this.jsiiGet("stackName", String.class);
    }

    @NotNull
    public IStackSynthesizer getSynthesizer() {
        return (IStackSynthesizer)this.jsiiGet("synthesizer", IStackSynthesizer.class);
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getTemplateFile() {
        return (String)this.jsiiGet("templateFile", String.class);
    }

    @NotNull
    public ITemplateOptions getTemplateOptions() {
        return (ITemplateOptions)this.jsiiGet("templateOptions", ITemplateOptions.class);
    }

    @NotNull
    public String getUrlSuffix() {
        return (String)this.jsiiGet("urlSuffix", String.class);
    }

    @Nullable
    public Stack getNestedStackParent() {
        return (Stack)this.jsiiGet("nestedStackParent", Stack.class);
    }

    @Nullable
    public CfnResource getNestedStackResource() {
        return (CfnResource)this.jsiiGet("nestedStackResource", CfnResource.class);
    }

    @Deprecated
    @Nullable
    public Stack getParentStack() {
        return (Stack)this.jsiiGet("parentStack", Stack.class);
    }

    @Nullable
    public Boolean getTerminationProtection() {
        return (Boolean)this.jsiiGet("terminationProtection", Boolean.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Stack> {
        private final Construct scope;
        private final String id;
        private StackProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        public static Builder create(Construct scope) {
            return new Builder(scope, null);
        }

        public static Builder create() {
            return new Builder(null, null);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder env(Environment env) {
            this.props().env(env);
            return this;
        }

        public Builder stackName(String stackName) {
            this.props().stackName(stackName);
            return this;
        }

        public Builder synthesizer(IStackSynthesizer synthesizer) {
            this.props().synthesizer(synthesizer);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder terminationProtection(Boolean terminationProtection) {
            this.props().terminationProtection(terminationProtection);
            return this;
        }

        public Stack build() {
            return new Stack(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private StackProps.Builder props() {
            if (this.props == null) {
                this.props = new StackProps.Builder();
            }
            return this.props;
        }
    }
}

