package software.amazon.awscdk.core;

/**
 * The location of the published file asset.
 * <p>
 * This is where the asset
 * can be consumed at runtime.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-07T13:18:03.879Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.FileAssetLocation")
@software.amazon.jsii.Jsii.Proxy(FileAssetLocation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileAssetLocation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The HTTP URL of this asset on Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * https:}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpUrl();

    /**
     * The Amazon S3 object key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

    /**
     * The S3 URL of this asset on Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * s3:}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectUrl();

    /**
     * The HTTP URL of this asset on Amazon S3.
     * <p>
     * @deprecated use `httpUrl`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @org.jetbrains.annotations.NotNull java.lang.String getS3Url();

    /**
     * The ARN of the KMS key used to encrypt the file asset bucket, if any.
     * <p>
     * If so, the consuming role should be given "kms:Decrypt" permissions in its
     * identity policy.
     * <p>
     * It's the responsibility of they key's creator to make sure that all
     * consumers that the key's key policy is configured such that the key can be used
     * by all consumers that need it.
     * <p>
     * The default bootstrap stack provisioned by the CDK CLI ensures this, and
     * can be used as an example for how to configure the key properly.
     * <p>
     * Default: - Asset bucket is not encrypted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileAssetLocation> {
        private java.lang.String bucketName;
        private java.lang.String httpUrl;
        private java.lang.String objectKey;
        private java.lang.String s3ObjectUrl;
        private java.lang.String s3Url;
        private java.lang.String kmsKeyArn;

        /**
         * Sets the value of {@link FileAssetLocation#getBucketName}
         * @param bucketName The name of the Amazon S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getHttpUrl}
         * @param httpUrl The HTTP URL of this asset on Amazon S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpUrl(java.lang.String httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getObjectKey}
         * @param objectKey The Amazon S3 object key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getS3ObjectUrl}
         * @param s3ObjectUrl The S3 URL of this asset on Amazon S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ObjectUrl(java.lang.String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getS3Url}
         * @param s3Url The HTTP URL of this asset on Amazon S3. This parameter is required.
         * @return {@code this}
         * @deprecated use `httpUrl`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder s3Url(java.lang.String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getKmsKeyArn}
         * @param kmsKeyArn The ARN of the KMS key used to encrypt the file asset bucket, if any.
         *                  If so, the consuming role should be given "kms:Decrypt" permissions in its
         *                  identity policy.
         *                  <p>
         *                  It's the responsibility of they key's creator to make sure that all
         *                  consumers that the key's key policy is configured such that the key can be used
         *                  by all consumers that need it.
         *                  <p>
         *                  The default bootstrap stack provisioned by the CDK CLI ensures this, and
         *                  can be used as an example for how to configure the key properly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetLocation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileAssetLocation build() {
            return new Jsii$Proxy(bucketName, httpUrl, objectKey, s3ObjectUrl, s3Url, kmsKeyArn);
        }
    }

    /**
     * An implementation for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAssetLocation {
        private final java.lang.String bucketName;
        private final java.lang.String httpUrl;
        private final java.lang.String objectKey;
        private final java.lang.String s3ObjectUrl;
        private final java.lang.String s3Url;
        private final java.lang.String kmsKeyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            this.httpUrl = this.jsiiGet("httpUrl", java.lang.String.class);
            this.objectKey = this.jsiiGet("objectKey", java.lang.String.class);
            this.s3ObjectUrl = this.jsiiGet("s3ObjectUrl", java.lang.String.class);
            this.s3Url = this.jsiiGet("s3Url", java.lang.String.class);
            this.kmsKeyArn = this.jsiiGet("kmsKeyArn", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String bucketName, final java.lang.String httpUrl, final java.lang.String objectKey, final java.lang.String s3ObjectUrl, final java.lang.String s3Url, final java.lang.String kmsKeyArn) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(bucketName, "bucketName is required");
            this.httpUrl = java.util.Objects.requireNonNull(httpUrl, "httpUrl is required");
            this.objectKey = java.util.Objects.requireNonNull(objectKey, "objectKey is required");
            this.s3ObjectUrl = java.util.Objects.requireNonNull(s3ObjectUrl, "s3ObjectUrl is required");
            this.s3Url = java.util.Objects.requireNonNull(s3Url, "s3Url is required");
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public java.lang.String getHttpUrl() {
            return this.httpUrl;
        }

        @Override
        public java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public java.lang.String getS3ObjectUrl() {
            return this.s3ObjectUrl;
        }

        @Override
        public java.lang.String getS3Url() {
            return this.s3Url;
        }

        @Override
        public java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("httpUrl", om.valueToTree(this.getHttpUrl()));
            data.set("objectKey", om.valueToTree(this.getObjectKey()));
            data.set("s3ObjectUrl", om.valueToTree(this.getS3ObjectUrl()));
            data.set("s3Url", om.valueToTree(this.getS3Url()));
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.FileAssetLocation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAssetLocation.Jsii$Proxy that = (FileAssetLocation.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!httpUrl.equals(that.httpUrl)) return false;
            if (!objectKey.equals(that.objectKey)) return false;
            if (!s3ObjectUrl.equals(that.s3ObjectUrl)) return false;
            if (!s3Url.equals(that.s3Url)) return false;
            return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.httpUrl.hashCode());
            result = 31 * result + (this.objectKey.hashCode());
            result = 31 * result + (this.s3ObjectUrl.hashCode());
            result = 31 * result + (this.s3Url.hashCode());
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            return result;
        }
    }
}
