package software.amazon.awscdk.core;

/**
 * Properties to provide a Lambda-backed custom resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-07T13:18:03.873Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CustomResourceProps")
@software.amazon.jsii.Jsii.Proxy(CustomResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the provider which implements this custom resource type.
     * <p>
     * You can implement a provider by listening to raw AWS CloudFormation events
     * and specify the ARN of an SNS topic (<code>topic.topicArn</code>) or the ARN of an AWS
     * Lambda function (<code>lambda.functionArn</code>) or use the CDK's custom <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html">resource
     * provider framework</a> which makes it easier to implement robust providers.
     * <p>
     * Provider framework:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * // use the provider framework from aws-cdk/custom-resources:
     * var provider = Provider.Builder.create()
     *         .onEventHandler(myOnEventLambda)
     *         .isCompleteHandler(myIsCompleteLambda)
     *         .build();
     * CustomResource.Builder.create(this, "MyResource")
     *         .serviceToken(provider.getServiceToken())
     *         .build();
     * </pre></blockquote>
     * <p>
     * AWS Lambda function:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * serviceToken: myFunction.functionArn
     * </pre></blockquote>
     * <p>
     * SNS topic:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * serviceToken: myTopic.topicArn
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceToken();

    /**
     * Convert all property keys to pascal case.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPascalCaseProperties() {
        return null;
    }

    /**
     * Properties to pass to the Lambda.
     * <p>
     * Default: - No properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getProperties() {
        return null;
    }

    /**
     * The policy to apply when this resource is removed from the application.
     * <p>
     * Default: cdk.RemovalPolicy.Destroy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
     * <p>
     * For example, you can use "Custom::MyCustomResourceTypeName".
     * <p>
     * Custom resource type names must begin with "Custom::" and can include
     * alphanumeric characters and the following characters: _&#64;-. You can specify
     * a custom resource type name up to a maximum length of 60 characters. You
     * cannot change the type during an update.
     * <p>
     * Using your own resource type names helps you quickly differentiate the
     * types of custom resources in your stack. For example, if you had two custom
     * resources that conduct two different ping tests, you could name their type
     * as Custom::PingTester to make them easily identifiable as ping testers
     * (instead of using AWS::CloudFormation::CustomResource).
     * <p>
     * Default: - AWS::CloudFormation::CustomResource
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomResourceProps> {
        private java.lang.String serviceToken;
        private java.lang.Boolean pascalCaseProperties;
        private java.util.Map<java.lang.String, java.lang.Object> properties;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private java.lang.String resourceType;

        /**
         * Sets the value of {@link CustomResourceProps#getServiceToken}
         * @param serviceToken The ARN of the provider which implements this custom resource type. This parameter is required.
         *                     You can implement a provider by listening to raw AWS CloudFormation events
         *                     and specify the ARN of an SNS topic (<code>topic.topicArn</code>) or the ARN of an AWS
         *                     Lambda function (<code>lambda.functionArn</code>) or use the CDK's custom <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html">resource
         *                     provider framework</a> which makes it easier to implement robust providers.
         *                     <p>
         *                     Provider framework:
         *                     <p>
         *                     <blockquote><pre>
         *                     // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         *                     // use the provider framework from aws-cdk/custom-resources:
         *                     var provider = Provider.Builder.create()
         *                             .onEventHandler(myOnEventLambda)
         *                             .isCompleteHandler(myIsCompleteLambda)
         *                             .build();
         *                     
         *                     CustomResource.Builder.create(this, "MyResource")
         *                             .serviceToken(provider.getServiceToken())
         *                             .build();
         *                     </pre></blockquote>
         *                     <p>
         *                     AWS Lambda function:
         *                     <p>
         *                     <blockquote><pre>
         *                     // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         *                     serviceToken: myFunction.functionArn
         *                     </pre></blockquote>
         *                     <p>
         *                     SNS topic:
         *                     <p>
         *                     <blockquote><pre>
         *                     // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         *                     serviceToken: myTopic.topicArn
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceToken(java.lang.String serviceToken) {
            this.serviceToken = serviceToken;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getPascalCaseProperties}
         * @param pascalCaseProperties Convert all property keys to pascal case.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pascalCaseProperties(java.lang.Boolean pascalCaseProperties) {
            this.pascalCaseProperties = pascalCaseProperties;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getProperties}
         * @param properties Properties to pass to the Lambda.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(java.util.Map<java.lang.String, java.lang.Object> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getRemovalPolicy}
         * @param removalPolicy The policy to apply when this resource is removed from the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getResourceType}
         * @param resourceType For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
         *                     For example, you can use "Custom::MyCustomResourceTypeName".
         *                     <p>
         *                     Custom resource type names must begin with "Custom::" and can include
         *                     alphanumeric characters and the following characters: _&#64;-. You can specify
         *                     a custom resource type name up to a maximum length of 60 characters. You
         *                     cannot change the type during an update.
         *                     <p>
         *                     Using your own resource type names helps you quickly differentiate the
         *                     types of custom resources in your stack. For example, if you had two custom
         *                     resources that conduct two different ping tests, you could name their type
         *                     as Custom::PingTester to make them easily identifiable as ping testers
         *                     (instead of using AWS::CloudFormation::CustomResource).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomResourceProps build() {
            return new Jsii$Proxy(serviceToken, pascalCaseProperties, properties, removalPolicy, resourceType);
        }
    }

    /**
     * An implementation for {@link CustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResourceProps {
        private final java.lang.String serviceToken;
        private final java.lang.Boolean pascalCaseProperties;
        private final java.util.Map<java.lang.String, java.lang.Object> properties;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.String resourceType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceToken = this.jsiiGet("serviceToken", java.lang.String.class);
            this.pascalCaseProperties = this.jsiiGet("pascalCaseProperties", java.lang.Boolean.class);
            this.properties = this.jsiiGet("properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String serviceToken, final java.lang.Boolean pascalCaseProperties, final java.util.Map<java.lang.String, java.lang.Object> properties, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final java.lang.String resourceType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceToken = java.util.Objects.requireNonNull(serviceToken, "serviceToken is required");
            this.pascalCaseProperties = pascalCaseProperties;
            this.properties = properties;
            this.removalPolicy = removalPolicy;
            this.resourceType = resourceType;
        }

        @Override
        public java.lang.String getServiceToken() {
            return this.serviceToken;
        }

        @Override
        public java.lang.Boolean getPascalCaseProperties() {
            return this.pascalCaseProperties;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getProperties() {
            return this.properties;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceToken", om.valueToTree(this.getServiceToken()));
            if (this.getPascalCaseProperties() != null) {
                data.set("pascalCaseProperties", om.valueToTree(this.getPascalCaseProperties()));
            }
            if (this.getProperties() != null) {
                data.set("properties", om.valueToTree(this.getProperties()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CustomResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomResourceProps.Jsii$Proxy that = (CustomResourceProps.Jsii$Proxy) o;

            if (!serviceToken.equals(that.serviceToken)) return false;
            if (this.pascalCaseProperties != null ? !this.pascalCaseProperties.equals(that.pascalCaseProperties) : that.pascalCaseProperties != null) return false;
            if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.resourceType != null ? this.resourceType.equals(that.resourceType) : that.resourceType == null;
        }

        @Override
        public int hashCode() {
            int result = this.serviceToken.hashCode();
            result = 31 * result + (this.pascalCaseProperties != null ? this.pascalCaseProperties.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            return result;
        }
    }
}
