package software.amazon.awscdk.core;

/**
 * Work with secret values in the CDK.
 * <p>
 * Secret values in the CDK (such as those retrieved from SecretsManager) are
 * represented as regular strings, just like other values that are only
 * available at deployment time.
 * <p>
 * To help you avoid accidental mistakes which would lead to you putting your
 * secret values directly into a CloudFormation template, constructs that take
 * secret values will not allow you to pass in a literal secret value. They do
 * so by calling <code>Secret.assertSafeSecret()</code>.
 * <p>
 * You can escape the check by calling <code>Secret.plainText()</code>, but doing
 * so is highly discouraged.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T17:21:08.760Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.SecretValue")
public class SecretValue extends software.amazon.awscdk.core.Intrinsic {

    protected SecretValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value });
    }

    /**
     * Obtain the secret value through a CloudFormation dynamic reference.
     * <p>
     * If possible, use <code>SecretValue.ssmSecure</code> or <code>SecretValue.secretsManager</code> directly.
     * <p>
     * @param ref The dynamic reference to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue cfnDynamicReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnDynamicReference ref) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "cfnDynamicReference", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(ref, "ref is required") });
    }

    /**
     * Obtain the secret value through a CloudFormation parameter.
     * <p>
     * Generally, this is not a recommended approach. AWS Secrets Manager is the
     * recommended way to reference secrets.
     * <p>
     * @param param The CloudFormation parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue cfnParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnParameter param) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "cfnParameter", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(param, "param is required") });
    }

    /**
     * Construct a literal secret value for use with secret-aware constructs.
     * <p>
     * <em>Do not use this method for any secrets that you care about.</em>
     * <p>
     * The only reasonable use case for using this method is when you are testing.
     * <p>
     * @param secret This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue plainText(final @org.jetbrains.annotations.NotNull java.lang.String secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "plainText", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretsManagerSecretOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "secretsManager", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required"), options });
    }

    /**
     * Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "secretsManager", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required") });
    }

    /**
     * Use a secret value stored from a Systems Manager (SSM) parameter.
     * <p>
     * @param parameterName The name of the parameter in the Systems Manager Parameter Store. This parameter is required.
     * @param version An integer that specifies the version of the parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue ssmSecure(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "ssmSecure", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(version, "version is required") });
    }
}
