/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.TagManagerOptions;
import software.amazon.awscdk.core.TagType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.TagManager")
public class TagManager
extends JsiiObject {
    protected TagManager(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TagManager(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TagManager(@NotNull TagType tagType, @NotNull String resourceTypeName, @Nullable Object tagStructure, @Nullable TagManagerOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(tagType, "tagType is required"), Objects.requireNonNull(resourceTypeName, "resourceTypeName is required"), tagStructure, options});
    }

    public TagManager(@NotNull TagType tagType, @NotNull String resourceTypeName, @Nullable Object tagStructure) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(tagType, "tagType is required"), Objects.requireNonNull(resourceTypeName, "resourceTypeName is required"), tagStructure});
    }

    public TagManager(@NotNull TagType tagType, @NotNull String resourceTypeName) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(tagType, "tagType is required"), Objects.requireNonNull(resourceTypeName, "resourceTypeName is required")});
    }

    @NotNull
    public static Boolean isTaggable(@NotNull Object construct) {
        return (Boolean)JsiiObject.jsiiStaticCall(TagManager.class, (String)"isTaggable", Boolean.class, (Object[])new Object[]{construct});
    }

    @NotNull
    public Boolean applyTagAspectHere(@Nullable List<String> include, @Nullable List<String> exclude) {
        return (Boolean)this.jsiiCall("applyTagAspectHere", Boolean.class, new Object[]{include, exclude});
    }

    @NotNull
    public Boolean applyTagAspectHere(@Nullable List<String> include) {
        return (Boolean)this.jsiiCall("applyTagAspectHere", Boolean.class, new Object[]{include});
    }

    @NotNull
    public Boolean applyTagAspectHere() {
        return (Boolean)this.jsiiCall("applyTagAspectHere", Boolean.class, new Object[0]);
    }

    @NotNull
    public Boolean hasTags() {
        return (Boolean)this.jsiiCall("hasTags", Boolean.class, new Object[0]);
    }

    public void removeTag(@NotNull String key, @NotNull Number priority) {
        this.jsiiCall("removeTag", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(priority, "priority is required")});
    }

    @NotNull
    public Object renderTags() {
        return this.jsiiCall("renderTags", Object.class, new Object[0]);
    }

    public void setTag(@NotNull String key, @NotNull String value, @Nullable Number priority, @Nullable Boolean applyToLaunchedInstances) {
        this.jsiiCall("setTag", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required"), priority, applyToLaunchedInstances});
    }

    public void setTag(@NotNull String key, @NotNull String value, @Nullable Number priority) {
        this.jsiiCall("setTag", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required"), priority});
    }

    public void setTag(@NotNull String key, @NotNull String value) {
        this.jsiiCall("setTag", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    @NotNull
    public String getTagPropertyName() {
        return (String)this.jsiiGet("tagPropertyName", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TagManager> {
        private final TagType tagType;
        private final String resourceTypeName;
        private final Object tagStructure;
        private TagManagerOptions.Builder options;

        public static Builder create(TagType tagType, String resourceTypeName, Object tagStructure) {
            return new Builder(tagType, resourceTypeName, tagStructure);
        }

        public static Builder create(TagType tagType, String resourceTypeName) {
            return new Builder(tagType, resourceTypeName, null);
        }

        private Builder(TagType tagType, String resourceTypeName, Object tagStructure) {
            this.tagType = tagType;
            this.resourceTypeName = resourceTypeName;
            this.tagStructure = tagStructure;
        }

        public Builder tagPropertyName(String tagPropertyName) {
            this.options().tagPropertyName(tagPropertyName);
            return this;
        }

        public TagManager build() {
            return new TagManager(this.tagType, this.resourceTypeName, this.tagStructure, this.options != null ? this.options.build() : null);
        }

        private TagManagerOptions.Builder options() {
            if (this.options == null) {
                this.options = new TagManagerOptions.Builder();
            }
            return this.options;
        }
    }
}

