package software.amazon.awscdk.core;

/**
 * Represents the amount of digital storage.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-24T18:52:00.823Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Size")
public class Size extends software.amazon.jsii.JsiiObject {

    protected Size(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Size(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a Storage representing an amount gibibytes.
     * <p>
     * 1 GiB = 1024 MiB
     * <p>
     * @param amount This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size gibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "gibibytes", software.amazon.awscdk.core.Size.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount kibibytes.
     * <p>
     * 1 KiB = 1024 bytes
     * <p>
     * @param amount This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size kibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "kibibytes", software.amazon.awscdk.core.Size.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount mebibytes.
     * <p>
     * 1 MiB = 1024 KiB
     * <p>
     * @param amount This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size mebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "mebibytes", software.amazon.awscdk.core.Size.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount pebibytes.
     * <p>
     * 1 PiB = 1024 TiB
     * <p>
     * @param amount This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size pebibyte(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "pebibyte", software.amazon.awscdk.core.Size.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount tebibytes.
     * <p>
     * 1 TiB = 1024 GiB
     * <p>
     * @param amount This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size tebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "tebibytes", software.amazon.awscdk.core.Size.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Return this storage as a total number of gibibytes.
     * <p>
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return this.jsiiCall("toGibibytes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return this storage as a total number of gibibytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes() {
        return this.jsiiCall("toGibibytes", java.lang.Number.class);
    }

    /**
     * Return this storage as a total number of kibibytes.
     * <p>
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return this.jsiiCall("toKibibytes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return this storage as a total number of kibibytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes() {
        return this.jsiiCall("toKibibytes", java.lang.Number.class);
    }

    /**
     * Return this storage as a total number of mebibytes.
     * <p>
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return this.jsiiCall("toMebibytes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return this storage as a total number of mebibytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes() {
        return this.jsiiCall("toMebibytes", java.lang.Number.class);
    }

    /**
     * Return this storage as a total number of pebibytes.
     * <p>
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return this.jsiiCall("toPebibytes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return this storage as a total number of pebibytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes() {
        return this.jsiiCall("toPebibytes", java.lang.Number.class);
    }

    /**
     * Return this storage as a total number of tebibytes.
     * <p>
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return this.jsiiCall("toTebibytes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * Return this storage as a total number of tebibytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes() {
        return this.jsiiCall("toTebibytes", java.lang.Number.class);
    }
}
