package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-24T18:52:00.813Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.RemovalPolicy")
public enum RemovalPolicy {
    /**
     * This is the default removal policy.
     * <p>
     * It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DESTROY,
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained in the account, but orphaned from the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RETAIN,
    /**
     * This retention policy deletes the resource, but saves a snapshot of its data before deleting, so that it can be re-created later.
     * <p>
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SNAPSHOT,
}
