package software.amazon.awscdk.core;

/**
 * To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-24T18:51:58.712Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnCodeDeployLambdaAliasUpdate")
@software.amazon.jsii.Jsii.Proxy(CfnCodeDeployLambdaAliasUpdate.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeDeployLambdaAliasUpdate extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the AWS CodeDeploy application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * The name of the AWS CodeDeploy deployment group.
     * <p>
     * This is where the traffic-shifting policy is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupName();

    /**
     * The name of the Lambda function to run after traffic routing completes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAfterAllowTrafficHook() {
        return null;
    }

    /**
     * The name of the Lambda function to run before traffic routing starts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBeforeAllowTrafficHook() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeDeployLambdaAliasUpdate> {
        private java.lang.String applicationName;
        private java.lang.String deploymentGroupName;
        private java.lang.String afterAllowTrafficHook;
        private java.lang.String beforeAllowTrafficHook;

        /**
         * Sets the value of {@link CfnCodeDeployLambdaAliasUpdate#getApplicationName}
         * @param applicationName The name of the AWS CodeDeploy application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployLambdaAliasUpdate#getDeploymentGroupName}
         * @param deploymentGroupName The name of the AWS CodeDeploy deployment group. This parameter is required.
         *                            This is where the traffic-shifting policy is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployLambdaAliasUpdate#getAfterAllowTrafficHook}
         * @param afterAllowTrafficHook The name of the Lambda function to run after traffic routing completes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder afterAllowTrafficHook(java.lang.String afterAllowTrafficHook) {
            this.afterAllowTrafficHook = afterAllowTrafficHook;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployLambdaAliasUpdate#getBeforeAllowTrafficHook}
         * @param beforeAllowTrafficHook The name of the Lambda function to run before traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder beforeAllowTrafficHook(java.lang.String beforeAllowTrafficHook) {
            this.beforeAllowTrafficHook = beforeAllowTrafficHook;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeDeployLambdaAliasUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCodeDeployLambdaAliasUpdate build() {
            return new Jsii$Proxy(applicationName, deploymentGroupName, afterAllowTrafficHook, beforeAllowTrafficHook);
        }
    }

    /**
     * An implementation for {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeDeployLambdaAliasUpdate {
        private final java.lang.String applicationName;
        private final java.lang.String deploymentGroupName;
        private final java.lang.String afterAllowTrafficHook;
        private final java.lang.String beforeAllowTrafficHook;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
            this.deploymentGroupName = this.jsiiGet("deploymentGroupName", java.lang.String.class);
            this.afterAllowTrafficHook = this.jsiiGet("afterAllowTrafficHook", java.lang.String.class);
            this.beforeAllowTrafficHook = this.jsiiGet("beforeAllowTrafficHook", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String applicationName, final java.lang.String deploymentGroupName, final java.lang.String afterAllowTrafficHook, final java.lang.String beforeAllowTrafficHook) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
            this.deploymentGroupName = java.util.Objects.requireNonNull(deploymentGroupName, "deploymentGroupName is required");
            this.afterAllowTrafficHook = afterAllowTrafficHook;
            this.beforeAllowTrafficHook = beforeAllowTrafficHook;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public java.lang.String getAfterAllowTrafficHook() {
            return this.afterAllowTrafficHook;
        }

        @Override
        public java.lang.String getBeforeAllowTrafficHook() {
            return this.beforeAllowTrafficHook;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            if (this.getAfterAllowTrafficHook() != null) {
                data.set("afterAllowTrafficHook", om.valueToTree(this.getAfterAllowTrafficHook()));
            }
            if (this.getBeforeAllowTrafficHook() != null) {
                data.set("beforeAllowTrafficHook", om.valueToTree(this.getBeforeAllowTrafficHook()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnCodeDeployLambdaAliasUpdate"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeDeployLambdaAliasUpdate.Jsii$Proxy that = (CfnCodeDeployLambdaAliasUpdate.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (!deploymentGroupName.equals(that.deploymentGroupName)) return false;
            if (this.afterAllowTrafficHook != null ? !this.afterAllowTrafficHook.equals(that.afterAllowTrafficHook) : that.afterAllowTrafficHook != null) return false;
            return this.beforeAllowTrafficHook != null ? this.beforeAllowTrafficHook.equals(that.beforeAllowTrafficHook) : that.beforeAllowTrafficHook == null;
        }

        @Override
        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.deploymentGroupName.hashCode());
            result = 31 * result + (this.afterAllowTrafficHook != null ? this.afterAllowTrafficHook.hashCode() : 0);
            result = 31 * result + (this.beforeAllowTrafficHook != null ? this.beforeAllowTrafficHook.hashCode() : 0);
            return result;
        }
    }
}
