package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-20T01:23:21.162Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DockerImageAssetSource")
@software.amazon.jsii.Jsii.Proxy(DockerImageAssetSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageAssetSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * The directory where the Dockerfile is stored, must be relative to the cloud assembly root.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectoryName();

    /**
     * The hash of the contents of the docker build context.
     * <p>
     * This hash is used
     * throughout the system to identify this image and avoid duplicate work
     * in case the source did not change.
     * <p>
     * NOTE: this means that if you wish to update your docker image, you
     * must make a modification to the source (e.g. add some metadata to your Dockerfile).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceHash();

    /**
     * Build args to pass to the `docker build` command.
     * <p>
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
     * <code>queue.queueUrl</code>).
     * <p>
     * Default: - no build args are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
        return null;
    }

    /**
     * Docker target to build to.
     * <p>
     * Default: - no target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerBuildTarget() {
        return null;
    }

    /**
     * Path to the Dockerfile (relative to the directory).
     * <p>
     * Default: - no file
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerFile() {
        return null;
    }

    /**
     * ECR repository name.
     * <p>
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     * <p>
     * Default: - automatically derived from the asset's ID.
     * <p>
     * @deprecated repository name should be specified at the environment-level and not at the image level
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageAssetSource> {
        private java.lang.String directoryName;
        private java.lang.String sourceHash;
        private java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private java.lang.String dockerBuildTarget;
        private java.lang.String dockerFile;
        private java.lang.String repositoryName;

        /**
         * Sets the value of {@link DockerImageAssetSource#getDirectoryName}
         * @param directoryName The directory where the Dockerfile is stored, must be relative to the cloud assembly root. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryName(java.lang.String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getSourceHash}
         * @param sourceHash The hash of the contents of the docker build context. This parameter is required.
         *                   This hash is used
         *                   throughout the system to identify this image and avoid duplicate work
         *                   in case the source did not change.
         *                   <p>
         *                   NOTE: this means that if you wish to update your docker image, you
         *                   must make a modification to the source (e.g. add some metadata to your Dockerfile).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDockerBuildArgs}
         * @param dockerBuildArgs Build args to pass to the `docker build` command.
         *                        Since Docker build arguments are resolved before deployment, keys and
         *                        values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         *                        <code>queue.queueUrl</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerBuildArgs(java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs) {
            this.dockerBuildArgs = dockerBuildArgs;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDockerBuildTarget}
         * @param dockerBuildTarget Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerBuildTarget(java.lang.String dockerBuildTarget) {
            this.dockerBuildTarget = dockerBuildTarget;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDockerFile}
         * @param dockerFile Path to the Dockerfile (relative to the directory).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerFile(java.lang.String dockerFile) {
            this.dockerFile = dockerFile;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getRepositoryName}
         * @param repositoryName ECR repository name.
         *                       Specify this property if you need to statically address the image, e.g.
         *                       from a Kubernetes Pod. Note, this is only the repository name, without the
         *                       registry and the tag parts.
         * @return {@code this}
         * @deprecated repository name should be specified at the environment-level and not at the image level
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerImageAssetSource build() {
            return new Jsii$Proxy(directoryName, sourceHash, dockerBuildArgs, dockerBuildTarget, dockerFile, repositoryName);
        }
    }

    /**
     * An implementation for {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageAssetSource {
        private final java.lang.String directoryName;
        private final java.lang.String sourceHash;
        private final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private final java.lang.String dockerBuildTarget;
        private final java.lang.String dockerFile;
        private final java.lang.String repositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.directoryName = this.jsiiGet("directoryName", java.lang.String.class);
            this.sourceHash = this.jsiiGet("sourceHash", java.lang.String.class);
            this.dockerBuildArgs = this.jsiiGet("dockerBuildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerBuildTarget = this.jsiiGet("dockerBuildTarget", java.lang.String.class);
            this.dockerFile = this.jsiiGet("dockerFile", java.lang.String.class);
            this.repositoryName = this.jsiiGet("repositoryName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String directoryName, final java.lang.String sourceHash, final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs, final java.lang.String dockerBuildTarget, final java.lang.String dockerFile, final java.lang.String repositoryName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.directoryName = java.util.Objects.requireNonNull(directoryName, "directoryName is required");
            this.sourceHash = java.util.Objects.requireNonNull(sourceHash, "sourceHash is required");
            this.dockerBuildArgs = dockerBuildArgs;
            this.dockerBuildTarget = dockerBuildTarget;
            this.dockerFile = dockerFile;
            this.repositoryName = repositoryName;
        }

        @Override
        public java.lang.String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
            return this.dockerBuildArgs;
        }

        @Override
        public java.lang.String getDockerBuildTarget() {
            return this.dockerBuildTarget;
        }

        @Override
        public java.lang.String getDockerFile() {
            return this.dockerFile;
        }

        @Override
        public java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("directoryName", om.valueToTree(this.getDirectoryName()));
            data.set("sourceHash", om.valueToTree(this.getSourceHash()));
            if (this.getDockerBuildArgs() != null) {
                data.set("dockerBuildArgs", om.valueToTree(this.getDockerBuildArgs()));
            }
            if (this.getDockerBuildTarget() != null) {
                data.set("dockerBuildTarget", om.valueToTree(this.getDockerBuildTarget()));
            }
            if (this.getDockerFile() != null) {
                data.set("dockerFile", om.valueToTree(this.getDockerFile()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.DockerImageAssetSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageAssetSource.Jsii$Proxy that = (DockerImageAssetSource.Jsii$Proxy) o;

            if (!directoryName.equals(that.directoryName)) return false;
            if (!sourceHash.equals(that.sourceHash)) return false;
            if (this.dockerBuildArgs != null ? !this.dockerBuildArgs.equals(that.dockerBuildArgs) : that.dockerBuildArgs != null) return false;
            if (this.dockerBuildTarget != null ? !this.dockerBuildTarget.equals(that.dockerBuildTarget) : that.dockerBuildTarget != null) return false;
            if (this.dockerFile != null ? !this.dockerFile.equals(that.dockerFile) : that.dockerFile != null) return false;
            return this.repositoryName != null ? this.repositoryName.equals(that.repositoryName) : that.repositoryName == null;
        }

        @Override
        public int hashCode() {
            int result = this.directoryName.hashCode();
            result = 31 * result + (this.sourceHash.hashCode());
            result = 31 * result + (this.dockerBuildArgs != null ? this.dockerBuildArgs.hashCode() : 0);
            result = 31 * result + (this.dockerBuildTarget != null ? this.dockerBuildTarget.hashCode() : 0);
            result = 31 * result + (this.dockerFile != null ? this.dockerFile.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            return result;
        }
    }
}
