package software.amazon.awscdk.core;

/**
 * Configuration properties for DefaultStackSynthesizer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T14:10:48.005Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DefaultStackSynthesizerProps")
@software.amazon.jsii.Jsii.Proxy(DefaultStackSynthesizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DefaultStackSynthesizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * External ID to use when assuming role for asset publishing.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetPublishingExternalId() {
        return null;
    }

    /**
     * The role to use to publish assets to this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_ASSET_PUBLISHING_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetPublishingRoleArn() {
        return null;
    }

    /**
     * The role CloudFormation will assume when deploying the Stack.
     * <p>
     * You must supply this if you have given a non-standard name to the execution role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRole() {
        return null;
    }

    /**
     * The role to assume to initiate a deployment in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleArn() {
        return null;
    }

    /**
     * Name of the S3 bucket to hold file assets.
     * <p>
     * You must supply this if you have given a non-standard name to the staging bucket.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetsBucketName() {
        return null;
    }

    /**
     * Name of the ECR repository to hold Docker Image assets.
     * <p>
     * You must supply this if you have given a non-standard name to the ECR repository.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetsRepositoryName() {
        return null;
    }

    /**
     * Qualifier to disambiguate multiple environments in the same account.
     * <p>
     * You can use this and leave the other naming properties empty if you have deployed
     * the bootstrap environment with standard names but only differnet qualifiers.
     * <p>
     * Default: - Value of context key '
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DefaultStackSynthesizerProps> {
        private java.lang.String assetPublishingExternalId;
        private java.lang.String assetPublishingRoleArn;
        private java.lang.String cloudFormationExecutionRole;
        private java.lang.String deployRoleArn;
        private java.lang.String fileAssetsBucketName;
        private java.lang.String imageAssetsRepositoryName;
        private java.lang.String qualifier;

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getAssetPublishingExternalId}
         * @param assetPublishingExternalId External ID to use when assuming role for asset publishing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetPublishingExternalId(java.lang.String assetPublishingExternalId) {
            this.assetPublishingExternalId = assetPublishingExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getAssetPublishingRoleArn}
         * @param assetPublishingRoleArn The role to use to publish assets to this environment.
         *                               You must supply this if you have given a non-standard name to the publishing role.
         *                               <p>
         *                               The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                               be replaced with the values of qualifier and the stack's account and region,
         *                               respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetPublishingRoleArn(java.lang.String assetPublishingRoleArn) {
            this.assetPublishingRoleArn = assetPublishingRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getCloudFormationExecutionRole}
         * @param cloudFormationExecutionRole The role CloudFormation will assume when deploying the Stack.
         *                                    You must supply this if you have given a non-standard name to the execution role.
         *                                    <p>
         *                                    The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                    be replaced with the values of qualifier and the stack's account and region,
         *                                    respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRole(java.lang.String cloudFormationExecutionRole) {
            this.cloudFormationExecutionRole = cloudFormationExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDeployRoleArn}
         * @param deployRoleArn The role to assume to initiate a deployment in this environment.
         *                      You must supply this if you have given a non-standard name to the publishing role.
         *                      <p>
         *                      The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                      be replaced with the values of qualifier and the stack's account and region,
         *                      respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(java.lang.String deployRoleArn) {
            this.deployRoleArn = deployRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetsBucketName}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets.
         *                             You must supply this if you have given a non-standard name to the staging bucket.
         *                             <p>
         *                             The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                             be replaced with the values of qualifier and the stack's account and region,
         *                             respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(java.lang.String fileAssetsBucketName) {
            this.fileAssetsBucketName = fileAssetsBucketName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetsRepositoryName}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets.
         *                                  You must supply this if you have given a non-standard name to the ECR repository.
         *                                  <p>
         *                                  The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                  be replaced with the values of qualifier and the stack's account and region,
         *                                  respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(java.lang.String imageAssetsRepositoryName) {
            this.imageAssetsRepositoryName = imageAssetsRepositoryName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getQualifier}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account.
         *                  You can use this and leave the other naming properties empty if you have deployed
         *                  the bootstrap environment with standard names but only differnet qualifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DefaultStackSynthesizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DefaultStackSynthesizerProps build() {
            return new Jsii$Proxy(assetPublishingExternalId, assetPublishingRoleArn, cloudFormationExecutionRole, deployRoleArn, fileAssetsBucketName, imageAssetsRepositoryName, qualifier);
        }
    }

    /**
     * An implementation for {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultStackSynthesizerProps {
        private final java.lang.String assetPublishingExternalId;
        private final java.lang.String assetPublishingRoleArn;
        private final java.lang.String cloudFormationExecutionRole;
        private final java.lang.String deployRoleArn;
        private final java.lang.String fileAssetsBucketName;
        private final java.lang.String imageAssetsRepositoryName;
        private final java.lang.String qualifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetPublishingExternalId = this.jsiiGet("assetPublishingExternalId", java.lang.String.class);
            this.assetPublishingRoleArn = this.jsiiGet("assetPublishingRoleArn", java.lang.String.class);
            this.cloudFormationExecutionRole = this.jsiiGet("cloudFormationExecutionRole", java.lang.String.class);
            this.deployRoleArn = this.jsiiGet("deployRoleArn", java.lang.String.class);
            this.fileAssetsBucketName = this.jsiiGet("fileAssetsBucketName", java.lang.String.class);
            this.imageAssetsRepositoryName = this.jsiiGet("imageAssetsRepositoryName", java.lang.String.class);
            this.qualifier = this.jsiiGet("qualifier", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String assetPublishingExternalId, final java.lang.String assetPublishingRoleArn, final java.lang.String cloudFormationExecutionRole, final java.lang.String deployRoleArn, final java.lang.String fileAssetsBucketName, final java.lang.String imageAssetsRepositoryName, final java.lang.String qualifier) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetPublishingExternalId = assetPublishingExternalId;
            this.assetPublishingRoleArn = assetPublishingRoleArn;
            this.cloudFormationExecutionRole = cloudFormationExecutionRole;
            this.deployRoleArn = deployRoleArn;
            this.fileAssetsBucketName = fileAssetsBucketName;
            this.imageAssetsRepositoryName = imageAssetsRepositoryName;
            this.qualifier = qualifier;
        }

        @Override
        public java.lang.String getAssetPublishingExternalId() {
            return this.assetPublishingExternalId;
        }

        @Override
        public java.lang.String getAssetPublishingRoleArn() {
            return this.assetPublishingRoleArn;
        }

        @Override
        public java.lang.String getCloudFormationExecutionRole() {
            return this.cloudFormationExecutionRole;
        }

        @Override
        public java.lang.String getDeployRoleArn() {
            return this.deployRoleArn;
        }

        @Override
        public java.lang.String getFileAssetsBucketName() {
            return this.fileAssetsBucketName;
        }

        @Override
        public java.lang.String getImageAssetsRepositoryName() {
            return this.imageAssetsRepositoryName;
        }

        @Override
        public java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetPublishingExternalId() != null) {
                data.set("assetPublishingExternalId", om.valueToTree(this.getAssetPublishingExternalId()));
            }
            if (this.getAssetPublishingRoleArn() != null) {
                data.set("assetPublishingRoleArn", om.valueToTree(this.getAssetPublishingRoleArn()));
            }
            if (this.getCloudFormationExecutionRole() != null) {
                data.set("cloudFormationExecutionRole", om.valueToTree(this.getCloudFormationExecutionRole()));
            }
            if (this.getDeployRoleArn() != null) {
                data.set("deployRoleArn", om.valueToTree(this.getDeployRoleArn()));
            }
            if (this.getFileAssetsBucketName() != null) {
                data.set("fileAssetsBucketName", om.valueToTree(this.getFileAssetsBucketName()));
            }
            if (this.getImageAssetsRepositoryName() != null) {
                data.set("imageAssetsRepositoryName", om.valueToTree(this.getImageAssetsRepositoryName()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.DefaultStackSynthesizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DefaultStackSynthesizerProps.Jsii$Proxy that = (DefaultStackSynthesizerProps.Jsii$Proxy) o;

            if (this.assetPublishingExternalId != null ? !this.assetPublishingExternalId.equals(that.assetPublishingExternalId) : that.assetPublishingExternalId != null) return false;
            if (this.assetPublishingRoleArn != null ? !this.assetPublishingRoleArn.equals(that.assetPublishingRoleArn) : that.assetPublishingRoleArn != null) return false;
            if (this.cloudFormationExecutionRole != null ? !this.cloudFormationExecutionRole.equals(that.cloudFormationExecutionRole) : that.cloudFormationExecutionRole != null) return false;
            if (this.deployRoleArn != null ? !this.deployRoleArn.equals(that.deployRoleArn) : that.deployRoleArn != null) return false;
            if (this.fileAssetsBucketName != null ? !this.fileAssetsBucketName.equals(that.fileAssetsBucketName) : that.fileAssetsBucketName != null) return false;
            if (this.imageAssetsRepositoryName != null ? !this.imageAssetsRepositoryName.equals(that.imageAssetsRepositoryName) : that.imageAssetsRepositoryName != null) return false;
            return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
        }

        @Override
        public int hashCode() {
            int result = this.assetPublishingExternalId != null ? this.assetPublishingExternalId.hashCode() : 0;
            result = 31 * result + (this.assetPublishingRoleArn != null ? this.assetPublishingRoleArn.hashCode() : 0);
            result = 31 * result + (this.cloudFormationExecutionRole != null ? this.cloudFormationExecutionRole.hashCode() : 0);
            result = 31 * result + (this.deployRoleArn != null ? this.deployRoleArn.hashCode() : 0);
            result = 31 * result + (this.fileAssetsBucketName != null ? this.fileAssetsBucketName.hashCode() : 0);
            result = 31 * result + (this.imageAssetsRepositoryName != null ? this.imageAssetsRepositoryName.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }
    }
}
