package software.amazon.awscdk.core;

/**
 * Initialization properties for `CustomResourceProvider`.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T00:02:05.826Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CustomResourceProviderProps")
@software.amazon.jsii.Jsii.Proxy(CustomResourceProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CustomResourceProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A local file system directory with the provider's code.
     * <p>
     * The code will be
     * bundled into a zip asset and wired to the provider's AWS Lambda function.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCodeDirectory();

    /**
     * The AWS Lambda runtime and version to use for the provider.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CustomResourceProviderRuntime getRuntime();

    /**
     * The amount of memory that your function has access to.
     * <p>
     * Increasing the
     * function's memory also increases its CPU allocation.
     * <p>
     * Default: Size.mebibytes(128)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getMemorySize() {
        return null;
    }

    /**
     * A set of IAM policy statements to include in the inline policy of the provider's lambda function.
     * <p>
     * Default: - no additional inline policy
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * policyStatements: [ { Effect: 'Allow', Action: 's3:PutObject*', Resource: '*' } ]}</pre></blockquote>
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getPolicyStatements() {
        return null;
    }

    /**
     * AWS Lambda timeout for the provider.
     * <p>
     * Default: Duration.minutes(15)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomResourceProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomResourceProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CustomResourceProviderProps> {
        private java.lang.String codeDirectory;
        private software.amazon.awscdk.core.CustomResourceProviderRuntime runtime;
        private software.amazon.awscdk.core.Size memorySize;
        private java.util.List<java.lang.Object> policyStatements;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link CustomResourceProviderProps#getCodeDirectory}
         * @param codeDirectory A local file system directory with the provider's code. This parameter is required.
         *                      The code will be
         *                      bundled into a zip asset and wired to the provider's AWS Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeDirectory(java.lang.String codeDirectory) {
            this.codeDirectory = codeDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderProps#getRuntime}
         * @param runtime The AWS Lambda runtime and version to use for the provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.core.CustomResourceProviderRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderProps#getMemorySize}
         * @param memorySize The amount of memory that your function has access to.
         *                   Increasing the
         *                   function's memory also increases its CPU allocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memorySize(software.amazon.awscdk.core.Size memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderProps#getPolicyStatements}
         * @param policyStatements A set of IAM policy statements to include in the inline policy of the provider's lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder policyStatements(java.util.List<java.lang.Object> policyStatements) {
            this.policyStatements = policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderProps#getTimeout}
         * @param timeout AWS Lambda timeout for the provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomResourceProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CustomResourceProviderProps build() {
            return new Jsii$Proxy(codeDirectory, runtime, memorySize, policyStatements, timeout);
        }
    }

    /**
     * An implementation for {@link CustomResourceProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResourceProviderProps {
        private final java.lang.String codeDirectory;
        private final software.amazon.awscdk.core.CustomResourceProviderRuntime runtime;
        private final software.amazon.awscdk.core.Size memorySize;
        private final java.util.List<java.lang.Object> policyStatements;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeDirectory = this.jsiiGet("codeDirectory", java.lang.String.class);
            this.runtime = this.jsiiGet("runtime", software.amazon.awscdk.core.CustomResourceProviderRuntime.class);
            this.memorySize = this.jsiiGet("memorySize", software.amazon.awscdk.core.Size.class);
            this.policyStatements = this.jsiiGet("policyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String codeDirectory, final software.amazon.awscdk.core.CustomResourceProviderRuntime runtime, final software.amazon.awscdk.core.Size memorySize, final java.util.List<java.lang.Object> policyStatements, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeDirectory = java.util.Objects.requireNonNull(codeDirectory, "codeDirectory is required");
            this.runtime = java.util.Objects.requireNonNull(runtime, "runtime is required");
            this.memorySize = memorySize;
            this.policyStatements = policyStatements;
            this.timeout = timeout;
        }

        @Override
        public java.lang.String getCodeDirectory() {
            return this.codeDirectory;
        }

        @Override
        public software.amazon.awscdk.core.CustomResourceProviderRuntime getRuntime() {
            return this.runtime;
        }

        @Override
        public software.amazon.awscdk.core.Size getMemorySize() {
            return this.memorySize;
        }

        @Override
        public java.util.List<java.lang.Object> getPolicyStatements() {
            return this.policyStatements;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("codeDirectory", om.valueToTree(this.getCodeDirectory()));
            data.set("runtime", om.valueToTree(this.getRuntime()));
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getPolicyStatements() != null) {
                data.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CustomResourceProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomResourceProviderProps.Jsii$Proxy that = (CustomResourceProviderProps.Jsii$Proxy) o;

            if (!codeDirectory.equals(that.codeDirectory)) return false;
            if (!runtime.equals(that.runtime)) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.policyStatements != null ? !this.policyStatements.equals(that.policyStatements) : that.policyStatements != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.codeDirectory.hashCode();
            result = 31 * result + (this.runtime.hashCode());
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.policyStatements != null ? this.policyStatements.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
