package software.amazon.awscdk.core;

/**
 * Stages a file or directory from a location on the file system into a staging directory.
 * <p>
 * This is controlled by the context key 'aws:cdk:asset-staging' and enabled
 * by the CLI by default in order to ensure that when the CDK app exists, all
 * assets are available for deployment. Otherwise, if an app references assets
 * in temporary locations, those will not be available when it exists (see
 * https://github.com/aws/aws-cdk/issues/1716).
 * <p>
 * The <code>stagedPath</code> property is a stringified token that represents the location
 * of the file or directory after staging. It will be resolved only during the
 * "prepare" stage and may be either the original path or the staged path
 * depending on the context setting.
 * <p>
 * The file/directory are staged based on their content hash (fingerprint). This
 * means that only if content was changed, copy will happen.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T00:02:05.792Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.AssetStaging")
public class AssetStaging extends software.amazon.awscdk.core.Construct {

    protected AssetStaging(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetStaging(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetStaging(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.AssetStagingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * <p>
     * This method is usually implemented by framework-level constructs such as <code>Stack</code> and <code>Asset</code>
     * as they participate in synthesizing the cloud assembly.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        this.jsiiCall("synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * A cryptographic hash of the source document(s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSourceHash() {
        return this.jsiiGet("sourceHash", java.lang.String.class);
    }

    /**
     * The path of the asset as it was referenced by the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSourcePath() {
        return this.jsiiGet("sourcePath", java.lang.String.class);
    }

    /**
     * The path to the asset (stringinfied token).
     * <p>
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStagedPath() {
        return this.jsiiGet("stagedPath", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.AssetStaging}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.AssetStaging> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.AssetStagingProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.AssetStagingProps.Builder();
        }

        /**
         * Glob patterns to exclude from the copy.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude Glob patterns to exclude from the copy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param follow A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder follow(final software.amazon.awscdk.core.SymlinkFollowMode follow) {
            this.props.follow(follow);
            return this;
        }

        /**
         * Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props.extraHash(extraHash);
            return this;
        }

        /**
         * The source file or directory to copy from.
         * <p>
         * @return {@code this}
         * @param sourcePath The source file or directory to copy from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcePath(final java.lang.String sourcePath) {
            this.props.sourcePath(sourcePath);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.AssetStaging}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.AssetStaging build() {
            return new software.amazon.awscdk.core.AssetStaging(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
