package software.amazon.awscdk.core;

/**
 * Deployment environment for a nested stack.
 * <p>
 * Interoperates with the StackSynthesizer of the parent stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-27T11:34:16.154Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.NestedStackSynthesizer")
public class NestedStackSynthesizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IStackSynthesizer {

    protected NestedStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NestedStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parentDeployment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NestedStackSynthesizer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStackSynthesizer parentDeployment) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parentDeployment, "parentDeployment is required") });
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource asset) {
        return this.jsiiCall("addDockerImageAsset", software.amazon.awscdk.core.DockerImageAssetLocation.class, new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource asset) {
        return this.jsiiCall("addFileAsset", software.amazon.awscdk.core.FileAssetLocation.class, new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param _stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack _stack) {
        this.jsiiCall("bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_stack, "_stack is required") });
    }

    /**
     * Synthesize all artifacts required for the stack into the session.
     * <p>
     * @param _session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesizeStackArtifacts(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession _session) {
        this.jsiiCall("synthesizeStackArtifacts", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_session, "_session is required") });
    }
}
