/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnStackProps;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnStack")
public class CfnStack
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStack.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnStack(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStack(@NotNull Construct scope, @NotNull String id, @NotNull CfnStackProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnStack fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnStack)JsiiObject.jsiiStaticCall(CfnStack.class, (String)"fromCloudFormation", CfnStack.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getTemplateUrl() {
        return (String)this.jsiiGet("templateUrl", String.class);
    }

    public void setTemplateUrl(@NotNull String value) {
        this.jsiiSet("templateUrl", Objects.requireNonNull(value, "templateUrl is required"));
    }

    @Nullable
    public List<String> getNotificationArns() {
        return Optional.ofNullable((List)this.jsiiGet("notificationArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setNotificationArns(@Nullable List<String> value) {
        this.jsiiSet("notificationArns", value);
    }

    @Nullable
    public Object getParameters() {
        return this.jsiiGet("parameters", Object.class);
    }

    public void setParameters(@Nullable IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    public void setParameters(@Nullable Map<String, String> value) {
        this.jsiiSet("parameters", value);
    }

    @Nullable
    public Number getTimeoutInMinutes() {
        return (Number)this.jsiiGet("timeoutInMinutes", Number.class);
    }

    public void setTimeoutInMinutes(@Nullable Number value) {
        this.jsiiSet("timeoutInMinutes", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnStackProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnStackProps.Builder();
        }

        public Builder templateUrl(String templateUrl) {
            this.props.templateUrl(templateUrl);
            return this;
        }

        public Builder notificationArns(List<String> notificationArns) {
            this.props.notificationArns(notificationArns);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeoutInMinutes(Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        public CfnStack build() {
            return new CfnStack(this.scope, this.id, this.props.build());
        }
    }
}

