package software.amazon.awscdk.core;

/**
 * CloudFormation intrinsic functions.
 * <p>
 * http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-15T23:35:46.862Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Fn")
public class Fn extends software.amazon.jsii.JsiiObject {

    protected Fn(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Fn(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The intrinsic function ``Fn::Base64`` returns the Base64 representation of the input string.
     * <p>
     * This function is typically used to pass encoded data to
     * Amazon EC2 instances by way of the UserData property.
     * <p>
     * @return a token represented as a string
     * @param data The string value you want to convert to Base64. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String base64(final @org.jetbrains.annotations.NotNull java.lang.String data) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "base64", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(data, "data is required") });
    }

    /**
     * The intrinsic function ``Fn::Cidr`` returns the specified Cidr address block.
     * <p>
     * @return a token represented as a string
     * @param ipBlock The user-specified default Cidr address block. This parameter is required.
     * @param count The number of subnets' Cidr block wanted. This parameter is required.
     * @param sizeMask The digit covered in the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> cidr(final @org.jetbrains.annotations.NotNull java.lang.String ipBlock, final @org.jetbrains.annotations.NotNull java.lang.Number count, final @org.jetbrains.annotations.Nullable java.lang.String sizeMask) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "cidr", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(ipBlock, "ipBlock is required"), java.util.Objects.requireNonNull(count, "count is required"), sizeMask }));
    }

    /**
     * The intrinsic function ``Fn::Cidr`` returns the specified Cidr address block.
     * <p>
     * @return a token represented as a string
     * @param ipBlock The user-specified default Cidr address block. This parameter is required.
     * @param count The number of subnets' Cidr block wanted. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> cidr(final @org.jetbrains.annotations.NotNull java.lang.String ipBlock, final @org.jetbrains.annotations.NotNull java.lang.Number count) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "cidr", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(ipBlock, "ipBlock is required"), java.util.Objects.requireNonNull(count, "count is required") }));
    }

    /**
     * Returns true if all the specified conditions evaluate to true, or returns false if any one of the conditions evaluates to false.
     * <p>
     * <code>Fn::And</code> acts as
     * an AND operator. The minimum number of conditions that you can include is
     * 2, and the maximum is 10.
     * <p>
     * @return an FnCondition token
     * @param conditions conditions to AND. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionAnd(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionAnd", software.amazon.awscdk.core.ICfnConditionExpression.class, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * Returns true if a specified string matches at least one value in a list of strings.
     * <p>
     * @return an FnCondition token
     * @param listOfStrings A list of strings, such as "A", "B", "C". This parameter is required.
     * @param value A string, such as "A", that you want to compare against a list of strings. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionContains(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listOfStrings, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionContains", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(listOfStrings, "listOfStrings is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Returns true if a specified string matches all values in a list.
     * <p>
     * @return an FnCondition token
     * @param listOfStrings A list of strings, such as "A", "B", "C". This parameter is required.
     * @param value A string, such as "A", that you want to compare against a list of strings. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionEachMemberEquals(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listOfStrings, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionEachMemberEquals", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(listOfStrings, "listOfStrings is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Returns true if each member in a list of strings matches at least one value in a second list of strings.
     * <p>
     * @return an FnCondition token
     * @param stringsToCheck A list of strings, such as "A", "B", "C". This parameter is required.
     * @param stringsToMatch A list of strings, such as "A", "B", "C". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionEachMemberIn(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> stringsToCheck, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> stringsToMatch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionEachMemberIn", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(stringsToCheck, "stringsToCheck is required"), java.util.Objects.requireNonNull(stringsToMatch, "stringsToMatch is required") });
    }

    /**
     * Compares if two values are equal.
     * <p>
     * Returns true if the two values are equal
     * or false if they aren't.
     * <p>
     * @return an FnCondition token
     * @param lhs A value of any type that you want to compare. This parameter is required.
     * @param rhs A value of any type that you want to compare. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionEquals(final @org.jetbrains.annotations.NotNull java.lang.Object lhs, final @org.jetbrains.annotations.NotNull java.lang.Object rhs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionEquals", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { lhs, rhs });
    }

    /**
     * Returns one value if the specified condition evaluates to true and another value if the specified condition evaluates to false.
     * <p>
     * Currently, AWS
     * CloudFormation supports the <code>Fn::If</code> intrinsic function in the metadata
     * attribute, update policy attribute, and property values in the Resources
     * section and Outputs sections of a template. You can use the AWS::NoValue
     * pseudo parameter as a return value to remove the corresponding property.
     * <p>
     * @return an FnCondition token
     * @param conditionId A reference to a condition in the Conditions section. This parameter is required.
     * @param valueIfTrue A value to be returned if the specified condition evaluates to true. This parameter is required.
     * @param valueIfFalse A value to be returned if the specified condition evaluates to false. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionIf(final @org.jetbrains.annotations.NotNull java.lang.String conditionId, final @org.jetbrains.annotations.NotNull java.lang.Object valueIfTrue, final @org.jetbrains.annotations.NotNull java.lang.Object valueIfFalse) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionIf", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(conditionId, "conditionId is required"), valueIfTrue, valueIfFalse });
    }

    /**
     * Returns true for a condition that evaluates to false or returns false for a condition that evaluates to true.
     * <p>
     * <code>Fn::Not</code> acts as a NOT operator.
     * <p>
     * @return an FnCondition token
     * @param condition A condition such as ``Fn::Equals`` that evaluates to true or false. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionNot(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression condition) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionNot", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required") });
    }

    /**
     * Returns true if any one of the specified conditions evaluate to true, or returns false if all of the conditions evaluates to false.
     * <p>
     * <code>Fn::Or</code> acts
     * as an OR operator. The minimum number of conditions that you can include is
     * 2, and the maximum is 10.
     * <p>
     * @return an FnCondition token
     * @param conditions conditions that evaluates to true or false. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression conditionOr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionOr", software.amazon.awscdk.core.ICfnConditionExpression.class, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * The intrinsic function ``Fn::FindInMap`` returns the value corresponding to keys in a two-level map that is declared in the Mappings section.
     * <p>
     * @return a token represented as a string
     * @param mapName This parameter is required.
     * @param topLevelKey This parameter is required.
     * @param secondLevelKey This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String findInMap(final @org.jetbrains.annotations.NotNull java.lang.String mapName, final @org.jetbrains.annotations.NotNull java.lang.String topLevelKey, final @org.jetbrains.annotations.NotNull java.lang.String secondLevelKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "findInMap", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(mapName, "mapName is required"), java.util.Objects.requireNonNull(topLevelKey, "topLevelKey is required"), java.util.Objects.requireNonNull(secondLevelKey, "secondLevelKey is required") });
    }

    /**
     * The ``Fn::GetAtt`` intrinsic function returns the value of an attribute from a resource in the template.
     * <p>
     * @return an IResolvable object
     * @param logicalNameOfResource The logical name (also called logical ID) of the resource that contains the attribute that you want. This parameter is required.
     * @param attributeName The name of the resource-specific attribute whose value you want. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAtt(final @org.jetbrains.annotations.NotNull java.lang.String logicalNameOfResource, final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "getAtt", software.amazon.awscdk.core.IResolvable.class, new Object[] { java.util.Objects.requireNonNull(logicalNameOfResource, "logicalNameOfResource is required"), java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * The intrinsic function ``Fn::GetAZs`` returns an array that lists Availability Zones for a specified region.
     * <p>
     * Because customers have access to
     * different Availability Zones, the intrinsic function <code>Fn::GetAZs</code> enables
     * template authors to write templates that adapt to the calling user's
     * access. That way you don't have to hard-code a full list of Availability
     * Zones for a specified region.
     * <p>
     * @return a token represented as a string array
     * @param region The name of the region for which you want to get the Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAzs(final @org.jetbrains.annotations.Nullable java.lang.String region) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "getAzs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { region }));
    }

    /**
     * The intrinsic function ``Fn::GetAZs`` returns an array that lists Availability Zones for a specified region.
     * <p>
     * Because customers have access to
     * different Availability Zones, the intrinsic function <code>Fn::GetAZs</code> enables
     * template authors to write templates that adapt to the calling user's
     * access. That way you don't have to hard-code a full list of Availability
     * Zones for a specified region.
     * <p>
     * @return a token represented as a string array
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAzs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "getAzs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The intrinsic function ``Fn::ImportValue`` returns the value of an output exported by another stack.
     * <p>
     * You typically use this function to create
     * cross-stack references. In the following example template snippets, Stack A
     * exports VPC security group values and Stack B imports them.
     * <p>
     * @return a token represented as a string
     * @param sharedValueToImport The stack output value that you want to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String importValue(final @org.jetbrains.annotations.NotNull java.lang.String sharedValueToImport) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "importValue", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(sharedValueToImport, "sharedValueToImport is required") });
    }

    /**
     * The intrinsic function ``Fn::Join`` appends a set of values into a single value, separated by the specified delimiter.
     * <p>
     * If a delimiter is the empty
     * string, the set of values are concatenated with no delimiter.
     * <p>
     * @return a token represented as a string
     * @param delimiter The value you want to occur between fragments. This parameter is required.
     * @param listOfValues The list of values you want combined. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String join(final @org.jetbrains.annotations.NotNull java.lang.String delimiter, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listOfValues) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "join", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(delimiter, "delimiter is required"), java.util.Objects.requireNonNull(listOfValues, "listOfValues is required") });
    }

    /**
     * The ``Ref`` intrinsic function returns the value of the specified parameter or resource.
     * <p>
     * Note that it doesn't validate the logicalName, it mainly serves paremeter/resource reference defined in a <code>CfnInclude</code> template.
     * <p>
     * @param logicalName The logical name of a parameter/resource for which you want to retrieve its value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String ref(final @org.jetbrains.annotations.NotNull java.lang.String logicalName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "ref", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(logicalName, "logicalName is required") });
    }

    /**
     * Returns all values for a specified parameter type.
     * <p>
     * @return a token represented as a string array
     * @param parameterType An AWS-specific parameter type, such as AWS::EC2::SecurityGroup::Id or AWS::EC2::VPC::Id. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> refAll(final @org.jetbrains.annotations.NotNull java.lang.String parameterType) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "refAll", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(parameterType, "parameterType is required") }));
    }

    /**
     * The intrinsic function ``Fn::Select`` returns a single object from a list of objects by index.
     * <p>
     * @return a token represented as a string
     * @param index The index of the object to retrieve. This parameter is required.
     * @param array The list of objects to select from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String select(final @org.jetbrains.annotations.NotNull java.lang.Number index, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> array) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "select", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(array, "array is required") });
    }

    /**
     * To split a string into a list of string values so that you can select an element from the resulting string list, use the ``Fn::Split`` intrinsic function.
     * <p>
     * Specify the location of splits
     * with a delimiter, such as , (a comma). After you split a string, use the <code>Fn::Select</code> function
     * to pick a specific element.
     * <p>
     * @return a token represented as a string array
     * @param delimiter A string value that determines where the source string is divided. This parameter is required.
     * @param source The string value that you want to split. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> split(final @org.jetbrains.annotations.NotNull java.lang.String delimiter, final @org.jetbrains.annotations.NotNull java.lang.String source) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "split", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(delimiter, "delimiter is required"), java.util.Objects.requireNonNull(source, "source is required") }));
    }

    /**
     * The intrinsic function ``Fn::Sub`` substitutes variables in an input string with values that you specify.
     * <p>
     * In your templates, you can use this function
     * to construct commands or outputs that include values that aren't available
     * until you create or update a stack.
     * <p>
     * @return a token represented as a string
     * @param body A string with variables that AWS CloudFormation substitutes with their associated values at runtime. This parameter is required.
     * @param variables The name of a variable that you included in the String parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String sub(final @org.jetbrains.annotations.NotNull java.lang.String body, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> variables) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "sub", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(body, "body is required"), variables });
    }

    /**
     * The intrinsic function ``Fn::Sub`` substitutes variables in an input string with values that you specify.
     * <p>
     * In your templates, you can use this function
     * to construct commands or outputs that include values that aren't available
     * until you create or update a stack.
     * <p>
     * @return a token represented as a string
     * @param body A string with variables that AWS CloudFormation substitutes with their associated values at runtime. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String sub(final @org.jetbrains.annotations.NotNull java.lang.String body) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "sub", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(body, "body is required") });
    }

    /**
     * Returns an attribute value or list of values for a specific parameter and attribute.
     * <p>
     * @return a token represented as a string
     * @param parameterOrLogicalId The name of a parameter for which you want to retrieve attribute values. This parameter is required.
     * @param attribute The name of an attribute from which you want to retrieve a value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueOf(final @org.jetbrains.annotations.NotNull java.lang.String parameterOrLogicalId, final @org.jetbrains.annotations.NotNull java.lang.String attribute) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "valueOf", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(parameterOrLogicalId, "parameterOrLogicalId is required"), java.util.Objects.requireNonNull(attribute, "attribute is required") });
    }

    /**
     * Returns a list of all attribute values for a given parameter type and attribute.
     * <p>
     * @return a token represented as a string array
     * @param parameterType An AWS-specific parameter type, such as AWS::EC2::SecurityGroup::Id or AWS::EC2::VPC::Id. This parameter is required.
     * @param attribute The name of an attribute from which you want to retrieve a value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> valueOfAll(final @org.jetbrains.annotations.NotNull java.lang.String parameterType, final @org.jetbrains.annotations.NotNull java.lang.String attribute) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "valueOfAll", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(parameterType, "parameterType is required"), java.util.Objects.requireNonNull(attribute, "attribute is required") }));
    }
}
