package software.amazon.awscdk.core;

/**
 * A CloudFormation `AWS::CloudFormation::Stack`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-05-05T15:27:53.069Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnStack")
public class CfnStack extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.CfnStack.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CloudFormation::Stack`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudFormation::Stack.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CloudFormation::Stack.TemplateURL`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateUrl() {
        return this.jsiiGet("templateUrl", java.lang.String.class);
    }

    /**
     * `AWS::CloudFormation::Stack.TemplateURL`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTemplateUrl(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("templateUrl", java.util.Objects.requireNonNull(value, "templateUrl is required"));
    }

    /**
     * `AWS::CloudFormation::Stack.NotificationARNs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::CloudFormation::Stack.NotificationARNs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNotificationArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("notificationArns", value);
    }

    /**
     * `AWS::CloudFormation::Stack.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return this.jsiiGet("parameters", java.lang.Object.class);
    }

    /**
     * `AWS::CloudFormation::Stack.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    /**
     * `AWS::CloudFormation::Stack.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("parameters", value);
    }

    /**
     * `AWS::CloudFormation::Stack.TimeoutInMinutes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
        return this.jsiiGet("timeoutInMinutes", java.lang.Number.class);
    }

    /**
     * `AWS::CloudFormation::Stack.TimeoutInMinutes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("timeoutInMinutes", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CfnStackProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CfnStackProps.Builder();
        }

        /**
         * `AWS::CloudFormation::Stack.TemplateURL`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
         * @param templateUrl `AWS::CloudFormation::Stack.TemplateURL`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder templateUrl(final java.lang.String templateUrl) {
            this.props.templateUrl(templateUrl);
            return this;
        }

        /**
         * `AWS::CloudFormation::Stack.NotificationARNs`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
         * @param notificationArns `AWS::CloudFormation::Stack.NotificationARNs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props.notificationArns(notificationArns);
            return this;
        }

        /**
         * `AWS::CloudFormation::Stack.Parameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
         * @param parameters `AWS::CloudFormation::Stack.Parameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder parameters(final software.amazon.awscdk.core.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * `AWS::CloudFormation::Stack.Parameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
         * @param parameters `AWS::CloudFormation::Stack.Parameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * `AWS::CloudFormation::Stack.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-tags
         * @param tags `AWS::CloudFormation::Stack.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::CloudFormation::Stack.TimeoutInMinutes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
         * @param timeoutInMinutes `AWS::CloudFormation::Stack.TimeoutInMinutes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder timeoutInMinutes(final java.lang.Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.core.CfnStack build() {
            return new software.amazon.awscdk.core.CfnStack(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
