package software.amazon.awscdk.core;

/**
 * A CloudFormation parameter.
 * <p>
 * Use the optional Parameters section to customize your templates.
 * Parameters enable you to input custom values to your template each time you create or
 * update a stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-05-05T15:27:53.063Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnParameter")
public class CfnParameter extends software.amazon.awscdk.core.CfnElement {

    protected CfnParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a parameter construct.
     * <p>
     * Note that the name (logical ID) of the parameter will derive from it's <code>coname</code> and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     * @param props The parameter properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnParameterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Creates a parameter construct.
     * <p>
     * Note that the name (logical ID) of the parameter will derive from it's <code>coname</code> and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param _context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext _context) {
        return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * Indicates if this parameter is configured with "NoEcho" enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getNoEcho() {
        return this.jsiiGet("noEcho", java.lang.Boolean.class);
    }

    /**
     * The parameter value as a Token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getValue() {
        return this.jsiiGet("value", software.amazon.awscdk.core.IResolvable.class);
    }

    /**
     * The parameter value, if it represents a string list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValueAsList() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("valueAsList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The parameter value, if it represents a number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getValueAsNumber() {
        return this.jsiiGet("valueAsNumber", java.lang.Number.class);
    }

    /**
     * The parameter value, if it represents a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValueAsString() {
        return this.jsiiGet("valueAsString", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnParameter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.CfnParameterProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A regular expression that represents the patterns to allow for String types.
         * <p>
         * Default: - No constraints on patterns allowed for parameter.
         * <p>
         * @return {@code this}
         * @param allowedPattern A regular expression that represents the patterns to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPattern(final java.lang.String allowedPattern) {
            this.props().allowedPattern(allowedPattern);
            return this;
        }

        /**
         * An array containing the list of values allowed for the parameter.
         * <p>
         * Default: - No constraints on values allowed for parameter.
         * <p>
         * @return {@code this}
         * @param allowedValues An array containing the list of values allowed for the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedValues(final java.util.List<java.lang.String> allowedValues) {
            this.props().allowedValues(allowedValues);
            return this;
        }

        /**
         * A string that explains a constraint when the constraint is violated.
         * <p>
         * For example, without a constraint description, a parameter that has an allowed
         * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
         * an invalid value:
         * <p>
         * Default: - No description with customized error message when user specifies invalid values.
         * <p>
         * @return {@code this}
         * @param constraintDescription A string that explains a constraint when the constraint is violated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder constraintDescription(final java.lang.String constraintDescription) {
            this.props().constraintDescription(constraintDescription);
            return this;
        }

        /**
         * A value of the appropriate type for the template to use if no value is specified when a stack is created.
         * <p>
         * If you define constraints for the parameter, you must specify
         * a value that adheres to those constraints.
         * <p>
         * Default: - No default value for parameter.
         * <p>
         * @return {@code this}
         * @param defaultValue A value of the appropriate type for the template to use if no value is specified when a stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final java.lang.Object defaultValue) {
            this.props().defaultValue(defaultValue);
            return this;
        }

        /**
         * A string of up to 4000 characters that describes the parameter.
         * <p>
         * Default: - No description for the parameter.
         * <p>
         * @return {@code this}
         * @param description A string of up to 4000 characters that describes the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * An integer value that determines the largest number of characters you want to allow for String types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param maxLength An integer value that determines the largest number of characters you want to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLength(final java.lang.Number maxLength) {
            this.props().maxLength(maxLength);
            return this;
        }

        /**
         * A numeric value that determines the largest numeric value you want to allow for Number types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param maxValue A numeric value that determines the largest numeric value you want to allow for Number types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxValue(final java.lang.Number maxValue) {
            this.props().maxValue(maxValue);
            return this;
        }

        /**
         * An integer value that determines the smallest number of characters you want to allow for String types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param minLength An integer value that determines the smallest number of characters you want to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLength(final java.lang.Number minLength) {
            this.props().minLength(minLength);
            return this;
        }

        /**
         * A numeric value that determines the smallest numeric value you want to allow for Number types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param minValue A numeric value that determines the smallest numeric value you want to allow for Number types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minValue(final java.lang.Number minValue) {
            this.props().minValue(minValue);
            return this;
        }

        /**
         * Whether to mask the parameter value when anyone makes a call that describes the stack.
         * <p>
         * If you set the value to <code>true</code>, the parameter value is masked with asterisks (<code>*****</code>).
         * <p>
         * Default: - Parameter values are not masked.
         * <p>
         * @return {@code this}
         * @param noEcho Whether to mask the parameter value when anyone makes a call that describes the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noEcho(final java.lang.Boolean noEcho) {
            this.props().noEcho(noEcho);
            return this;
        }

        /**
         * The data type for the parameter (DataType).
         * <p>
         * Default: String
         * <p>
         * @return {@code this}
         * @param type The data type for the parameter (DataType). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnParameter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.CfnParameter build() {
            return new software.amazon.awscdk.core.CfnParameter(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.CfnParameterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.CfnParameterProps.Builder();
            }
            return this.props;
        }
    }
}
