package software.amazon.awscdk.core;

/**
 * Initialization properties for `AssetStaging`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-05-05T15:27:53.053Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.AssetStagingProps")
@software.amazon.jsii.Jsii.Proxy(AssetStagingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetStagingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.FingerprintOptions {

    /**
     * The source file or directory to copy from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourcePath();

    /**
     * @return a {@link Builder} of {@link AssetStagingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetStagingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String sourcePath;
        private java.lang.String extraHash;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.core.SymlinkFollowMode follow;

        /**
         * Sets the value of {@link AssetStagingProps#getSourcePath}
         * @param sourcePath The source file or directory to copy from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcePath(java.lang.String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getExtraHash}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(java.lang.String extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link AssetStagingProps#getFollow}
         * @param follow A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder follow(software.amazon.awscdk.core.SymlinkFollowMode follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetStagingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AssetStagingProps build() {
            return new Jsii$Proxy(sourcePath, extraHash, exclude, follow);
        }
    }

    /**
     * An implementation for {@link AssetStagingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetStagingProps {
        private final java.lang.String sourcePath;
        private final java.lang.String extraHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.core.SymlinkFollowMode follow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourcePath = this.jsiiGet("sourcePath", java.lang.String.class);
            this.extraHash = this.jsiiGet("extraHash", java.lang.String.class);
            this.exclude = this.jsiiGet("exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.follow = this.jsiiGet("follow", software.amazon.awscdk.core.SymlinkFollowMode.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String sourcePath, final java.lang.String extraHash, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.core.SymlinkFollowMode follow) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourcePath = java.util.Objects.requireNonNull(sourcePath, "sourcePath is required");
            this.extraHash = extraHash;
            this.exclude = exclude;
            this.follow = follow;
        }

        @Override
        public java.lang.String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public java.lang.String getExtraHash() {
            return this.extraHash;
        }

        @Override
        public java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public software.amazon.awscdk.core.SymlinkFollowMode getFollow() {
            return this.follow;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourcePath", om.valueToTree(this.getSourcePath()));
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollow() != null) {
                data.set("follow", om.valueToTree(this.getFollow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.AssetStagingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetStagingProps.Jsii$Proxy that = (AssetStagingProps.Jsii$Proxy) o;

            if (!sourcePath.equals(that.sourcePath)) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            return this.follow != null ? this.follow.equals(that.follow) : that.follow == null;
        }

        @Override
        public int hashCode() {
            int result = this.sourcePath.hashCode();
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.follow != null ? this.follow.hashCode() : 0);
            return result;
        }
    }
}
