/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.ConstructOrder;
import software.amazon.awscdk.core.Dependency;
import software.amazon.awscdk.core.IAspect;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.SynthesisOptions;
import software.amazon.awscdk.core.ValidationError;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.MetadataEntry;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.ConstructNode")
public class ConstructNode
extends JsiiObject {
    public static final String PATH_SEP = (String)JsiiObject.jsiiStaticGet(ConstructNode.class, (String)"PATH_SEP", String.class);

    protected ConstructNode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConstructNode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ConstructNode(@NotNull Construct host, @NotNull IConstruct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static void prepare(@NotNull ConstructNode node) {
        JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"prepare", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    @NotNull
    public static CloudAssembly synth(@NotNull ConstructNode root, @Nullable SynthesisOptions options) {
        return (CloudAssembly)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"synth", CloudAssembly.class, (Object[])new Object[]{Objects.requireNonNull(root, "root is required"), options});
    }

    @NotNull
    public static CloudAssembly synth(@NotNull ConstructNode root) {
        return (CloudAssembly)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"synth", CloudAssembly.class, (Object[])new Object[]{Objects.requireNonNull(root, "root is required")});
    }

    @NotNull
    public static List<ValidationError> validate(@NotNull ConstructNode node) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ValidationError.class)), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")}));
    }

    public void addDependency(IDependable ... dependencies) {
        this.jsiiCall("addDependency", NativeType.VOID, Arrays.stream(dependencies).toArray(Object[]::new));
    }

    public void addError(@NotNull String message) {
        this.jsiiCall("addError", NativeType.VOID, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void addInfo(@NotNull String message) {
        this.jsiiCall("addInfo", NativeType.VOID, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void addMetadata(@NotNull String type, @NotNull Object data, @Nullable Object fromFunction) {
        this.jsiiCall("addMetadata", NativeType.VOID, new Object[]{Objects.requireNonNull(type, "type is required"), data, fromFunction});
    }

    public void addMetadata(@NotNull String type, @NotNull Object data) {
        this.jsiiCall("addMetadata", NativeType.VOID, new Object[]{Objects.requireNonNull(type, "type is required"), data});
    }

    public void addWarning(@NotNull String message) {
        this.jsiiCall("addWarning", NativeType.VOID, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void applyAspect(@NotNull IAspect aspect) {
        this.jsiiCall("applyAspect", NativeType.VOID, new Object[]{Objects.requireNonNull(aspect, "aspect is required")});
    }

    @NotNull
    public List<IConstruct> findAll(@Nullable ConstructOrder order) {
        return Collections.unmodifiableList((List)this.jsiiCall("findAll", NativeType.listOf((NativeType)NativeType.forClass(IConstruct.class)), new Object[]{order}));
    }

    @NotNull
    public List<IConstruct> findAll() {
        return Collections.unmodifiableList((List)this.jsiiCall("findAll", NativeType.listOf((NativeType)NativeType.forClass(IConstruct.class)), new Object[0]));
    }

    @NotNull
    public IConstruct findChild(@NotNull String id) {
        return (IConstruct)this.jsiiCall("findChild", IConstruct.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public void setContext(@NotNull String key, @NotNull Object value) {
        this.jsiiCall("setContext", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    @Nullable
    public IConstruct tryFindChild(@NotNull String id) {
        return (IConstruct)this.jsiiCall("tryFindChild", IConstruct.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Object tryGetContext(@NotNull String key) {
        return this.jsiiCall("tryGetContext", Object.class, new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    @NotNull
    public Boolean tryRemoveChild(@NotNull String childName) {
        return (Boolean)this.jsiiCall("tryRemoveChild", Boolean.class, new Object[]{Objects.requireNonNull(childName, "childName is required")});
    }

    @NotNull
    public List<IConstruct> getChildren() {
        return Collections.unmodifiableList((List)this.jsiiGet("children", NativeType.listOf((NativeType)NativeType.forClass(IConstruct.class))));
    }

    @NotNull
    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("dependencies", NativeType.listOf((NativeType)NativeType.forClass(Dependency.class))));
    }

    @NotNull
    public String getId() {
        return (String)this.jsiiGet("id", String.class);
    }

    @NotNull
    public Boolean getLocked() {
        return (Boolean)this.jsiiGet("locked", Boolean.class);
    }

    @NotNull
    public List<MetadataEntry> getMetadata() {
        return Collections.unmodifiableList((List)this.jsiiGet("metadata", NativeType.listOf((NativeType)NativeType.forClass(MetadataEntry.class))));
    }

    @NotNull
    public String getPath() {
        return (String)this.jsiiGet("path", String.class);
    }

    @NotNull
    public IConstruct getRoot() {
        return (IConstruct)this.jsiiGet("root", IConstruct.class);
    }

    @NotNull
    public List<IConstruct> getScopes() {
        return Collections.unmodifiableList((List)this.jsiiGet("scopes", NativeType.listOf((NativeType)NativeType.forClass(IConstruct.class))));
    }

    @NotNull
    public String getUniqueId() {
        return (String)this.jsiiGet("uniqueId", String.class);
    }

    @Nullable
    public IConstruct getScope() {
        return (IConstruct)this.jsiiGet("scope", IConstruct.class);
    }

    @Nullable
    public IConstruct getDefaultChild() {
        return (IConstruct)this.jsiiGet("defaultChild", IConstruct.class);
    }

    public void setDefaultChild(@Nullable IConstruct value) {
        this.jsiiSet("defaultChild", value);
    }
}

