package software.amazon.awscdk.core;

/**
 * Options for referencing a secret value from Secrets Manager.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:00.276Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.SecretsManagerSecretOptions")
@software.amazon.jsii.Jsii.Proxy(SecretsManagerSecretOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretsManagerSecretOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key of a JSON field to retrieve.
     * <p>
     * This can only be used if the secret
     * stores a JSON object.
     * <p>
     * Default: - returns all the content stored in the Secrets Manager secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJsonField() {
        return null;
    }

    /**
     * Specifies the unique identifier of the version of the secret you want to use.
     * <p>
     * Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
     * <p>
     * Default: AWSCURRENT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionId() {
        return null;
    }

    /**
     * Specified the secret version that you want to retrieve by the staging label attached to the version.
     * <p>
     * Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
     * <p>
     * Default: AWSCURRENT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String jsonField;
        private java.lang.String versionId;
        private java.lang.String versionStage;

        /**
         * Sets the value of {@link SecretsManagerSecretOptions#getJsonField}
         * @param jsonField The key of a JSON field to retrieve.
         *                  This can only be used if the secret
         *                  stores a JSON object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonField(java.lang.String jsonField) {
            this.jsonField = jsonField;
            return this;
        }

        /**
         * Sets the value of {@link SecretsManagerSecretOptions#getVersionId}
         * @param versionId Specifies the unique identifier of the version of the secret you want to use.
         *                  Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionId(java.lang.String versionId) {
            this.versionId = versionId;
            return this;
        }

        /**
         * Sets the value of {@link SecretsManagerSecretOptions#getVersionStage}
         * @param versionStage Specified the secret version that you want to retrieve by the staging label attached to the version.
         *                     Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionStage(java.lang.String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretsManagerSecretOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SecretsManagerSecretOptions build() {
            return new Jsii$Proxy(jsonField, versionId, versionStage);
        }
    }

    /**
     * An implementation for {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretsManagerSecretOptions {
        private final java.lang.String jsonField;
        private final java.lang.String versionId;
        private final java.lang.String versionStage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jsonField = this.jsiiGet("jsonField", java.lang.String.class);
            this.versionId = this.jsiiGet("versionId", java.lang.String.class);
            this.versionStage = this.jsiiGet("versionStage", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String jsonField, final java.lang.String versionId, final java.lang.String versionStage) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jsonField = jsonField;
            this.versionId = versionId;
            this.versionStage = versionStage;
        }

        @Override
        public java.lang.String getJsonField() {
            return this.jsonField;
        }

        @Override
        public java.lang.String getVersionId() {
            return this.versionId;
        }

        @Override
        public java.lang.String getVersionStage() {
            return this.versionStage;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJsonField() != null) {
                data.set("jsonField", om.valueToTree(this.getJsonField()));
            }
            if (this.getVersionId() != null) {
                data.set("versionId", om.valueToTree(this.getVersionId()));
            }
            if (this.getVersionStage() != null) {
                data.set("versionStage", om.valueToTree(this.getVersionStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.SecretsManagerSecretOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretsManagerSecretOptions.Jsii$Proxy that = (SecretsManagerSecretOptions.Jsii$Proxy) o;

            if (this.jsonField != null ? !this.jsonField.equals(that.jsonField) : that.jsonField != null) return false;
            if (this.versionId != null ? !this.versionId.equals(that.versionId) : that.versionId != null) return false;
            return this.versionStage != null ? this.versionStage.equals(that.versionStage) : that.versionStage == null;
        }

        @Override
        public int hashCode() {
            int result = this.jsonField != null ? this.jsonField.hashCode() : 0;
            result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
            result = 31 * result + (this.versionStage != null ? this.versionStage.hashCode() : 0);
            return result;
        }
    }
}
