/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnElement;
import software.amazon.awscdk.core.CfnParameterProps;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.IResolveContext;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/core.CfnParameter")
public class CfnParameter
extends CfnElement {
    protected CfnParameter(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnParameter(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnParameter(@NotNull Construct scope, @NotNull String id, @Nullable CfnParameterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnParameter(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Object resolve(@NotNull IResolveContext _context) {
        return this.jsiiCall("resolve", Object.class, new Object[]{Objects.requireNonNull(_context, "_context is required")});
    }

    @NotNull
    public Boolean getNoEcho() {
        return (Boolean)this.jsiiGet("noEcho", Boolean.class);
    }

    @NotNull
    public IResolvable getValue() {
        return (IResolvable)this.jsiiGet("value", IResolvable.class);
    }

    @NotNull
    public List<String> getValueAsList() {
        return Collections.unmodifiableList((List)this.jsiiGet("valueAsList", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Number getValueAsNumber() {
        return (Number)this.jsiiGet("valueAsNumber", Number.class);
    }

    @NotNull
    public String getValueAsString() {
        return (String)this.jsiiGet("valueAsString", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private CfnParameterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder allowedPattern(String allowedPattern) {
            this.props().allowedPattern(allowedPattern);
            return this;
        }

        public Builder allowedValues(List<String> allowedValues) {
            this.props().allowedValues(allowedValues);
            return this;
        }

        public Builder constraintDescription(String constraintDescription) {
            this.props().constraintDescription(constraintDescription);
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.props().defaultValue(defaultValue);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder maxLength(Number maxLength) {
            this.props().maxLength(maxLength);
            return this;
        }

        public Builder maxValue(Number maxValue) {
            this.props().maxValue(maxValue);
            return this;
        }

        public Builder minLength(Number minLength) {
            this.props().minLength(minLength);
            return this;
        }

        public Builder minValue(Number minValue) {
            this.props().minValue(minValue);
            return this;
        }

        public Builder noEcho(Boolean noEcho) {
            this.props().noEcho(noEcho);
            return this;
        }

        public Builder type(String type) {
            this.props().type(type);
            return this;
        }

        public CfnParameter build() {
            return new CfnParameter(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnParameterProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnParameterProps.Builder();
            }
            return this.props;
        }
    }
}

