package software.amazon.awscdk.core;

/**
 * Represents a CloudFormation resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-09T11:48:02.433Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnResource")
public class CfnResource extends software.amazon.awscdk.core.CfnRefElement {

    protected CfnResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a resource construct.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Check whether the given construct is a CfnResource.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.CfnResource.class, "isCfnResource", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Syntactic sugar for `addOverride(path, undefined)`.
     * <p>
     * @param path The path of the value to delete. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeletionOverride(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        this.jsiiCall("addDeletionOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Indicates that this resource depends on another resource and cannot be provisioned unless the other resource has been successfully provisioned.
     * <p>
     * This can be used for resources across stacks (or nested stack) boundaries
     * and the dependency will automatically be transferred to the relevant scope.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependsOn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnResource target) {
        this.jsiiCall("addDependsOn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Adds an override to the synthesized CloudFormation resource.
     * <p>
     * To add a
     * property override, either use <code>addPropertyOverride</code> or prefix <code>path</code> with
     * "Properties." (i.e. <code>Properties.TopicName</code>).
     * <p>
     * If the override is nested, separate each nested level using a dot (.) in the path parameter.
     * If there is an array as part of the nesting, specify the index in the path.
     * <p>
     * For example,
     * <p>
     * <blockquote><pre>
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * addOverride("Properties.GlobalSecondaryIndexes.0.Projection.NonKeyAttributes", asList("myattribute"));
     * addOverride("Properties.GlobalSecondaryIndexes.1.ProjectionType", "INCLUDE");
     * </pre></blockquote>
     * <p>
     * would add the overrides
     * <p>
     * <blockquote><pre>
     * "Properties": {
     *    "GlobalSecondaryIndexes": [
     *      {
     *        "Projection": {
     *          "NonKeyAttributes": [ "myattribute" ]
     *          ...
     *        }
     *        ...
     *      },
     *      {
     *        "ProjectionType": "INCLUDE"
     *        ...
     *      },
     *    ]
     *    ...
     * }
     * </pre></blockquote>
     * <p>
     * @param path - The path of the property, you can use dot notation to override values in complex types. This parameter is required.
     * @param value - The value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addOverride(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiCall("addOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), value });
    }

    /**
     * Adds an override that deletes the value of a property from the resource definition.
     * <p>
     * @param propertyPath The path to the property. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPropertyDeletionOverride(final @org.jetbrains.annotations.NotNull java.lang.String propertyPath) {
        this.jsiiCall("addPropertyDeletionOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(propertyPath, "propertyPath is required") });
    }

    /**
     * Adds an override to a resource property.
     * <p>
     * Syntactic sugar for <code>addOverride("Properties.&lt;...&gt;", value)</code>.
     * <p>
     * @param propertyPath The path of the property. This parameter is required.
     * @param value The value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPropertyOverride(final @org.jetbrains.annotations.NotNull java.lang.String propertyPath, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiCall("addPropertyOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(propertyPath, "propertyPath is required"), value });
    }

    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     * <p>
     * @param policy
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyRemovalPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy policy, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicyOptions options) {
        this.jsiiCall("applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { policy, options });
    }

    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     * <p>
     * @param policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyRemovalPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy policy) {
        this.jsiiCall("applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { policy });
    }

    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyRemovalPolicy() {
        this.jsiiCall("applyRemovalPolicy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Returns a token for an runtime attribute of this resource.
     * <p>
     * Ideally, use generated attribute accessors (e.g. <code>resource.arn</code>), but this can be used for future compatibility
     * in case there is no generated attribute.
     * <p>
     * @param attributeName The name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return this.jsiiCall("getAtt", software.amazon.awscdk.core.Reference.class, new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * Returns a string representation of this construct.
     * <p>
     * @return a string representation of this resource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * @param _properties This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void validateProperties(final @org.jetbrains.annotations.NotNull java.lang.Object _properties) {
        this.jsiiCall("validateProperties", software.amazon.jsii.NativeType.VOID, new Object[] { _properties });
    }

    /**
     * Options for this resource, such as condition, update policy etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnResourceOptions getCfnOptions() {
        return this.jsiiGet("cfnOptions", software.amazon.awscdk.core.ICfnResourceOptions.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * AWS resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCfnResourceType() {
        return this.jsiiGet("cfnResourceType", java.lang.String.class);
    }

    /**
     * Return properties modified after initiation.
     * <p>
     * Resources that expose mutable properties should override this function to
     * collect and return the properties object for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getUpdatedProperites() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("updatedProperites", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CfnResourceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CfnResourceProps.Builder();
        }

        /**
         * CloudFormation resource type (e.g. `AWS::S3::Bucket`).
         * <p>
         * @return {@code this}
         * @param type CloudFormation resource type (e.g. `AWS::S3::Bucket`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Resource properties.
         * <p>
         * Default: - No resource properties.
         * <p>
         * @return {@code this}
         * @param properties Resource properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final java.util.Map<java.lang.String, java.lang.Object> properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.CfnResource build() {
            return new software.amazon.awscdk.core.CfnResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
