package software.amazon.awscdk.core;

/**
 * The deployment environment for a stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-03T11:43:00.593Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Environment")
@software.amazon.jsii.Jsii.Proxy(Environment.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Environment extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID for this environment.
     * <p>
     * This can be either a concrete value such as <code>585191031104</code> or <code>Aws.accountId</code> which
     * indicates that account ID will only be determined during deployment (it
     * will resolve to the CloudFormation intrinsic <code>{"Ref":"AWS::AccountId"}</code>).
     * Note that certain features, such as cross-stack references and
     * environmental context providers require concerete region information and
     * will cause this stack to emit synthesis errors.
     * <p>
     * Default: Aws.accountId which means that the stack will be account-agnostic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getAccount() {
        return null;
    }

    /**
     * The AWS region for this environment.
     * <p>
     * This can be either a concrete value such as <code>eu-west-2</code> or <code>Aws.region</code>
     * which indicates that account ID will only be determined during deployment
     * (it will resolve to the CloudFormation intrinsic <code>{"Ref":"AWS::Region"}</code>).
     * Note that certain features, such as cross-stack references and
     * environmental context providers require concerete region information and
     * will cause this stack to emit synthesis errors.
     * <p>
     * Default: Aws.region which means that the stack will be region-agnostic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Environment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Environment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String account;
        private java.lang.String region;

        /**
         * Sets the value of {@link Environment#getAccount}
         * @param account The AWS account ID for this environment.
         *                This can be either a concrete value such as <code>585191031104</code> or <code>Aws.accountId</code> which
         *                indicates that account ID will only be determined during deployment (it
         *                will resolve to the CloudFormation intrinsic <code>{"Ref":"AWS::AccountId"}</code>).
         *                Note that certain features, such as cross-stack references and
         *                environmental context providers require concerete region information and
         *                will cause this stack to emit synthesis errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link Environment#getRegion}
         * @param region The AWS region for this environment.
         *               This can be either a concrete value such as <code>eu-west-2</code> or <code>Aws.region</code>
         *               which indicates that account ID will only be determined during deployment
         *               (it will resolve to the CloudFormation intrinsic <code>{"Ref":"AWS::Region"}</code>).
         *               Note that certain features, such as cross-stack references and
         *               environmental context providers require concerete region information and
         *               will cause this stack to emit synthesis errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Environment}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Environment build() {
            return new Jsii$Proxy(account, region);
        }
    }

    /**
     * An implementation for {@link Environment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Environment {
        private final java.lang.String account;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = this.jsiiGet("account", java.lang.String.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String account, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = account;
            this.region = region;
        }

        @Override
        public java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.Environment"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Environment.Jsii$Proxy that = (Environment.Jsii$Proxy) o;

            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.account != null ? this.account.hashCode() : 0;
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
