package software.amazon.awscdk.core;

/**
 * Represents a CloudFormation condition, for resources which must be conditionally created and the determination must be made at deploy time.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-03T11:43:00.569Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnCondition")
public class CfnCondition extends software.amazon.awscdk.core.CfnElement implements software.amazon.awscdk.core.ICfnConditionExpression,software.amazon.awscdk.core.IResolvable {

    protected CfnCondition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCondition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Build a new condition.
     * <p>
     * The condition must be constructed with a condition token,
     * that the condition is based on.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCondition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnConditionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Build a new condition.
     * <p>
     * The condition must be constructed with a condition token,
     * that the condition is based on.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCondition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Synthesizes the condition.
     * <p>
     * @param _context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext _context) {
        return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * The condition statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.ICfnConditionExpression getExpression() {
        return this.jsiiGet("expression", software.amazon.awscdk.core.ICfnConditionExpression.class);
    }

    /**
     * The condition statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExpression(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.ICfnConditionExpression value) {
        this.jsiiSet("expression", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnCondition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.CfnConditionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The expression that the condition will evaluate.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param expression The expression that the condition will evaluate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(final software.amazon.awscdk.core.ICfnConditionExpression expression) {
            this.props().expression(expression);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnCondition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.CfnCondition build() {
            return new software.amazon.awscdk.core.CfnCondition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.CfnConditionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.CfnConditionProps.Builder();
            }
            return this.props;
        }
    }
}
