package software.amazon.awscdk.core;

/**
 * Representation of validation results.
 * <p>
 * Models a tree of validation errors so that we have as much information as possible
 * about the failure that occurred.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-02-07T03:00:48.125Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.ValidationResult")
public class ValidationResult extends software.amazon.jsii.JsiiObject {

    protected ValidationResult(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ValidationResult(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param errorMessage
     * @param results
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ValidationResult(final java.lang.String errorMessage, final software.amazon.awscdk.core.ValidationResults results) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { errorMessage, results });
    }

    /**
     * @param errorMessage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ValidationResult(final java.lang.String errorMessage) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { errorMessage });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ValidationResult() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Turn a failed validation into an exception.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void assertSuccess() {
        this.jsiiCall("assertSuccess", Void.class);
    }

    /**
     * Return a string rendering of the tree of validation failures.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String errorTree() {
        return this.jsiiCall("errorTree", java.lang.String.class);
    }

    /**
     * Wrap this result with an error message, if it concerns an error.
     * <p>
     * @param message This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ValidationResult prefix(final java.lang.String message) {
        return this.jsiiCall("prefix", software.amazon.awscdk.core.ValidationResult.class, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getErrorMessage() {
        return this.jsiiGet("errorMessage", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getIsSuccess() {
        return this.jsiiGet("isSuccess", java.lang.Boolean.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ValidationResults getResults() {
        return this.jsiiGet("results", software.amazon.awscdk.core.ValidationResults.class);
    }
}
