/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.ArnComponents;
import software.amazon.awscdk.core.CfnElement;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.DockerImageAssetLocation;
import software.amazon.awscdk.core.DockerImageAssetSource;
import software.amazon.awscdk.core.Environment;
import software.amazon.awscdk.core.FileAssetLocation;
import software.amazon.awscdk.core.FileAssetSource;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.ISynthesisSession;
import software.amazon.awscdk.core.ITaggable;
import software.amazon.awscdk.core.ITemplateOptions;
import software.amazon.awscdk.core.Reference;
import software.amazon.awscdk.core.StackProps;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.cxapi.MissingContext;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/core.Stack")
public class Stack
extends Construct
implements ITaggable {
    protected Stack(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stack(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Stack(Construct scope, String id, StackProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope, id, props});
    }

    public Stack(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope, id});
    }

    public Stack(Construct scope) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope});
    }

    public Stack() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    public static Boolean isStack(Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Stack.class, (String)"isStack", Boolean.class, (Object[])new Object[]{x});
    }

    public static Stack of(IConstruct construct) {
        return (Stack)JsiiObject.jsiiStaticCall(Stack.class, (String)"of", Stack.class, (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    public void addDependency(Stack target, String reason) {
        this.jsiiCall("addDependency", Void.class, new Object[]{Objects.requireNonNull(target, "target is required"), reason});
    }

    public void addDependency(Stack target) {
        this.jsiiCall("addDependency", Void.class, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public DockerImageAssetLocation addDockerImageAsset(DockerImageAssetSource asset) {
        return (DockerImageAssetLocation)this.jsiiCall("addDockerImageAsset", DockerImageAssetLocation.class, new Object[]{Objects.requireNonNull(asset, "asset is required")});
    }

    public FileAssetLocation addFileAsset(FileAssetSource asset) {
        return (FileAssetLocation)this.jsiiCall("addFileAsset", FileAssetLocation.class, new Object[]{Objects.requireNonNull(asset, "asset is required")});
    }

    public void addTransform(String transform) {
        this.jsiiCall("addTransform", Void.class, new Object[]{Objects.requireNonNull(transform, "transform is required")});
    }

    protected String allocateLogicalId(CfnElement cfnElement) {
        return (String)this.jsiiCall("allocateLogicalId", String.class, new Object[]{Objects.requireNonNull(cfnElement, "cfnElement is required")});
    }

    public String formatArn(ArnComponents components) {
        return (String)this.jsiiCall("formatArn", String.class, new Object[]{Objects.requireNonNull(components, "components is required")});
    }

    public String getLogicalId(CfnElement element) {
        return (String)this.jsiiCall("getLogicalId", String.class, new Object[]{Objects.requireNonNull(element, "element is required")});
    }

    public ArnComponents parseArn(String arn, String sepIfToken, Boolean hasName) {
        return (ArnComponents)this.jsiiCall("parseArn", ArnComponents.class, new Object[]{Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName});
    }

    public ArnComponents parseArn(String arn, String sepIfToken) {
        return (ArnComponents)this.jsiiCall("parseArn", ArnComponents.class, new Object[]{Objects.requireNonNull(arn, "arn is required"), sepIfToken});
    }

    public ArnComponents parseArn(String arn) {
        return (ArnComponents)this.jsiiCall("parseArn", ArnComponents.class, new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    @Override
    protected void prepare() {
        this.jsiiCall("prepare", Void.class, new Object[0]);
    }

    protected IResolvable prepareCrossReference(Stack sourceStack, Reference reference) {
        return (IResolvable)this.jsiiCall("prepareCrossReference", IResolvable.class, new Object[]{Objects.requireNonNull(sourceStack, "sourceStack is required"), Objects.requireNonNull(reference, "reference is required")});
    }

    public void renameLogicalId(String oldId, String newId) {
        this.jsiiCall("renameLogicalId", Void.class, new Object[]{Objects.requireNonNull(oldId, "oldId is required"), Objects.requireNonNull(newId, "newId is required")});
    }

    public void reportMissingContext(MissingContext report) {
        this.jsiiCall("reportMissingContext", Void.class, new Object[]{Objects.requireNonNull(report, "report is required")});
    }

    public Object resolve(Object obj) {
        return this.jsiiCall("resolve", Object.class, new Object[]{obj});
    }

    @Override
    protected void synthesize(ISynthesisSession session) {
        this.jsiiCall("synthesize", Void.class, new Object[]{Objects.requireNonNull(session, "session is required")});
    }

    public String toJsonString(Object obj, Number space) {
        return (String)this.jsiiCall("toJsonString", String.class, new Object[]{obj, space});
    }

    public String toJsonString(Object obj) {
        return (String)this.jsiiCall("toJsonString", String.class, new Object[]{obj});
    }

    public String getAccount() {
        return (String)this.jsiiGet("account", String.class);
    }

    public String getArtifactId() {
        return (String)this.jsiiGet("artifactId", String.class);
    }

    public List<String> getAvailabilityZones() {
        return Collections.unmodifiableList((List)this.jsiiGet("availabilityZones", List.class));
    }

    public List<Stack> getDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("dependencies", List.class));
    }

    public String getEnvironment() {
        return (String)this.jsiiGet("environment", String.class);
    }

    public Boolean getNested() {
        return (Boolean)this.jsiiGet("nested", Boolean.class);
    }

    public List<String> getNotificationArns() {
        return Collections.unmodifiableList((List)this.jsiiGet("notificationArns", List.class));
    }

    public String getPartition() {
        return (String)this.jsiiGet("partition", String.class);
    }

    public String getRegion() {
        return (String)this.jsiiGet("region", String.class);
    }

    public String getStackId() {
        return (String)this.jsiiGet("stackId", String.class);
    }

    public String getStackName() {
        return (String)this.jsiiGet("stackName", String.class);
    }

    @Override
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    public String getTemplateFile() {
        return (String)this.jsiiGet("templateFile", String.class);
    }

    public ITemplateOptions getTemplateOptions() {
        return (ITemplateOptions)this.jsiiGet("templateOptions", ITemplateOptions.class);
    }

    public String getTemplateUrl() {
        return (String)this.jsiiGet("templateUrl", String.class);
    }

    public String getUrlSuffix() {
        return (String)this.jsiiGet("urlSuffix", String.class);
    }

    public Stack getNestedStackParent() {
        return (Stack)this.jsiiGet("nestedStackParent", Stack.class);
    }

    public CfnResource getNestedStackResource() {
        return (CfnResource)this.jsiiGet("nestedStackResource", CfnResource.class);
    }

    @Deprecated
    public Stack getParentStack() {
        return (Stack)this.jsiiGet("parentStack", Stack.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private StackProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        public static Builder create(Construct scope) {
            return new Builder(scope, null);
        }

        public static Builder create() {
            return new Builder(null, null);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder env(Environment env) {
            this.props().env(env);
            return this;
        }

        public Builder stackName(String stackName) {
            this.props().stackName(stackName);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props().tags(tags);
            return this;
        }

        public Stack build() {
            return new Stack(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private StackProps.Builder props() {
            if (this.props == null) {
                this.props = new StackProps.Builder();
            }
            return this.props;
        }
    }
}

