/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.TagManagerOptions;
import software.amazon.awscdk.core.TagType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.TagManager")
public class TagManager
extends JsiiObject {
    protected TagManager(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TagManager(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TagManager(TagType tagType, String resourceTypeName, Object tagStructure, TagManagerOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(tagType, "tagType is required"), Objects.requireNonNull(resourceTypeName, "resourceTypeName is required"), tagStructure, options});
    }

    public TagManager(TagType tagType, String resourceTypeName, Object tagStructure) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(tagType, "tagType is required"), Objects.requireNonNull(resourceTypeName, "resourceTypeName is required"), tagStructure});
    }

    public TagManager(TagType tagType, String resourceTypeName) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(tagType, "tagType is required"), Objects.requireNonNull(resourceTypeName, "resourceTypeName is required")});
    }

    public static Boolean isTaggable(Object construct) {
        return (Boolean)JsiiObject.jsiiStaticCall(TagManager.class, (String)"isTaggable", Boolean.class, (Object[])new Object[]{construct});
    }

    public Boolean applyTagAspectHere(List<String> include, List<String> exclude) {
        return (Boolean)this.jsiiCall("applyTagAspectHere", Boolean.class, new Object[]{include, exclude});
    }

    public Boolean applyTagAspectHere(List<String> include) {
        return (Boolean)this.jsiiCall("applyTagAspectHere", Boolean.class, new Object[]{include});
    }

    public Boolean applyTagAspectHere() {
        return (Boolean)this.jsiiCall("applyTagAspectHere", Boolean.class, new Object[0]);
    }

    public Boolean hasTags() {
        return (Boolean)this.jsiiCall("hasTags", Boolean.class, new Object[0]);
    }

    public void removeTag(String key, Number priority) {
        this.jsiiCall("removeTag", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(priority, "priority is required")});
    }

    public Object renderTags() {
        return this.jsiiCall("renderTags", Object.class, new Object[0]);
    }

    public void setTag(String key, String value, Number priority, Boolean applyToLaunchedInstances) {
        this.jsiiCall("setTag", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required"), priority, applyToLaunchedInstances});
    }

    public void setTag(String key, String value, Number priority) {
        this.jsiiCall("setTag", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required"), priority});
    }

    public void setTag(String key, String value) {
        this.jsiiCall("setTag", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    public String getTagPropertyName() {
        return (String)this.jsiiGet("tagPropertyName", String.class);
    }

    public static final class Builder {
        private final TagType tagType;
        private final String resourceTypeName;
        private final Object tagStructure;
        private TagManagerOptions.Builder options;

        public static Builder create(TagType tagType, String resourceTypeName, Object tagStructure) {
            return new Builder(tagType, resourceTypeName, tagStructure);
        }

        public static Builder create(TagType tagType, String resourceTypeName) {
            return new Builder(tagType, resourceTypeName, null);
        }

        private Builder(TagType tagType, String resourceTypeName, Object tagStructure) {
            this.tagType = tagType;
            this.resourceTypeName = resourceTypeName;
            this.tagStructure = tagStructure;
        }

        public Builder tagPropertyName(String tagPropertyName) {
            this.options().tagPropertyName(tagPropertyName);
            return this;
        }

        public TagManager build() {
            return new TagManager(this.tagType, this.resourceTypeName, this.tagStructure, this.options != null ? this.options.build() : null);
        }

        private TagManagerOptions.Builder options() {
            if (this.options == null) {
                this.options = new TagManagerOptions.Builder();
            }
            return this.options;
        }
    }
}

