/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.ConstructOrder;
import software.amazon.awscdk.core.Dependency;
import software.amazon.awscdk.core.IAspect;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.SynthesisOptions;
import software.amazon.awscdk.core.ValidationError;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.MetadataEntry;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/core.ConstructNode")
public class ConstructNode
extends JsiiObject {
    public static final String PATH_SEP = (String)JsiiObject.jsiiStaticGet(ConstructNode.class, (String)"PATH_SEP", String.class);

    protected ConstructNode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConstructNode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ConstructNode(Construct host, IConstruct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static void prepare(ConstructNode node) {
        JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"prepare", Void.class, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public static CloudAssembly synth(ConstructNode root, SynthesisOptions options) {
        return (CloudAssembly)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"synth", CloudAssembly.class, (Object[])new Object[]{Objects.requireNonNull(root, "root is required"), options});
    }

    public static CloudAssembly synth(ConstructNode root) {
        return (CloudAssembly)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"synth", CloudAssembly.class, (Object[])new Object[]{Objects.requireNonNull(root, "root is required")});
    }

    public static List<ValidationError> validate(ConstructNode node) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"validate", List.class, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")}));
    }

    public void addDependency(IDependable ... dependencies) {
        this.jsiiCall("addDependency", Void.class, Arrays.stream(dependencies).toArray(Object[]::new));
    }

    public void addError(String message) {
        this.jsiiCall("addError", Void.class, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void addInfo(String message) {
        this.jsiiCall("addInfo", Void.class, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void addMetadata(String type, Object data, Object from) {
        this.jsiiCall("addMetadata", Void.class, new Object[]{Objects.requireNonNull(type, "type is required"), data, from});
    }

    public void addMetadata(String type, Object data) {
        this.jsiiCall("addMetadata", Void.class, new Object[]{Objects.requireNonNull(type, "type is required"), data});
    }

    public void addWarning(String message) {
        this.jsiiCall("addWarning", Void.class, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void applyAspect(IAspect aspect) {
        this.jsiiCall("applyAspect", Void.class, new Object[]{Objects.requireNonNull(aspect, "aspect is required")});
    }

    public List<IConstruct> findAll(ConstructOrder order) {
        return Collections.unmodifiableList((List)this.jsiiCall("findAll", List.class, new Object[]{order}));
    }

    public List<IConstruct> findAll() {
        return Collections.unmodifiableList((List)this.jsiiCall("findAll", List.class, new Object[0]));
    }

    public IConstruct findChild(String id) {
        return (IConstruct)this.jsiiCall("findChild", IConstruct.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public void setContext(String key, Object value) {
        this.jsiiCall("setContext", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public IConstruct tryFindChild(String id) {
        return (IConstruct)this.jsiiCall("tryFindChild", IConstruct.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public Object tryGetContext(String key) {
        return this.jsiiCall("tryGetContext", Object.class, new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    public Boolean tryRemoveChild(String childName) {
        return (Boolean)this.jsiiCall("tryRemoveChild", Boolean.class, new Object[]{Objects.requireNonNull(childName, "childName is required")});
    }

    public List<IConstruct> getChildren() {
        return Collections.unmodifiableList((List)this.jsiiGet("children", List.class));
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("dependencies", List.class));
    }

    public String getId() {
        return (String)this.jsiiGet("id", String.class);
    }

    public Boolean getLocked() {
        return (Boolean)this.jsiiGet("locked", Boolean.class);
    }

    public List<MetadataEntry> getMetadata() {
        return Collections.unmodifiableList((List)this.jsiiGet("metadata", List.class));
    }

    public String getPath() {
        return (String)this.jsiiGet("path", String.class);
    }

    public IConstruct getRoot() {
        return (IConstruct)this.jsiiGet("root", IConstruct.class);
    }

    public List<IConstruct> getScopes() {
        return Collections.unmodifiableList((List)this.jsiiGet("scopes", List.class));
    }

    public String getUniqueId() {
        return (String)this.jsiiGet("uniqueId", String.class);
    }

    public IConstruct getScope() {
        return (IConstruct)this.jsiiGet("scope", IConstruct.class);
    }

    public IConstruct getDefaultChild() {
        return (IConstruct)this.jsiiGet("defaultChild", IConstruct.class);
    }

    public void setDefaultChild(IConstruct value) {
        this.jsiiSet("defaultChild", value);
    }
}

