package software.amazon.awscdk.core;

/**
 * Base class for referenceable CloudFormation constructs which are not Resources.
 * 
 * <p>These constructs are things like Conditions and Parameters, can be
 * referenced by taking the <code>.ref</code> attribute.</p>
 * <p>Resource constructs do not inherit from CfnRefElement because they have their
 * own, more specific types returned from the .ref attribute. Also, some
 * resources aren't referenceable at all (such as BucketPolicies or GatewayAttachments).</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.11 (build d4fd44f)", date = "2019-12-17T13:05:19.624Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnRefElement")
public abstract class CfnRefElement extends software.amazon.awscdk.core.CfnElement {

    protected CfnRefElement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRefElement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates an entity and binds it to a tree. Note that the root of the tree must be a Stack object (not just any Root).
     * 
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected CfnRefElement(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return a string that will be resolved to a CloudFormation `{ Ref }` for this element.
     * 
     * <p>If, by any chance, the intrinsic reference of a resource is not a string, you could
     * coerce it to an IResolvable through <code>Lazy.any({ produce: resource.ref })</code>.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRef() {
        return this.jsiiGet("ref", java.lang.String.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.core.CfnRefElement {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }
    }
}
