package software.amazon.awscdk.core;

/**
 * Represents a special or lazily-evaluated value.
 * 
 * <p>Can be used to delay evaluation of a certain value in case, for example,
 * that it requires some context or late-bound data. Can also be used to
 * mark values that need special processing at document rendering time.</p>
 * <p>Tokens can be embedded into strings while retaining their original
 * semantics.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:09.475Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Token")
public class Token extends software.amazon.jsii.JsiiObject {

    protected Token(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Token(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Return a resolvable representation of the given value.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.IResolvable asAny(final java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asAny", software.amazon.awscdk.core.IResolvable.class, new Object[] { value });
    }

    /**
     * Return a reversible list representation of this token.
     * 
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.util.List<java.lang.String> asList(final java.lang.Object value, final software.amazon.awscdk.core.EncodingOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asList", java.util.List.class, new Object[] { value, options }));
    }

    /**
     * Return a reversible list representation of this token.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.util.List<java.lang.String> asList(final java.lang.Object value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asList", java.util.List.class, new Object[] { value }));
    }

    /**
     * Return a reversible number representation of this token.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Number asNumber(final java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asNumber", java.lang.Number.class, new Object[] { value });
    }

    /**
     * Return a reversible string representation of this token.
     * 
     * <p>If the Token is initialized with a literal, the stringified value of the
     * literal is returned. Otherwise, a special quoted string representation
     * of the Token is returned that can be embedded into other strings.</p>
     * <p>Strings with quoted Tokens in them can be restored back into
     * complex values with the Tokens restored by calling <code>resolve()</code>
     * on the string.</p>
     * 
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.String asString(final java.lang.Object value, final software.amazon.awscdk.core.EncodingOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asString", java.lang.String.class, new Object[] { value, options });
    }

    /**
     * Return a reversible string representation of this token.
     * 
     * <p>If the Token is initialized with a literal, the stringified value of the
     * literal is returned. Otherwise, a special quoted string representation
     * of the Token is returned that can be embedded into other strings.</p>
     * <p>Strings with quoted Tokens in them can be restored back into
     * complex values with the Tokens restored by calling <code>resolve()</code>
     * on the string.</p>
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.String asString(final java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asString", java.lang.String.class, new Object[] { value });
    }

    /**
     * Returns true if obj represents an unresolved value.
     * 
     * <p>One of these must be true:</p>
     * <ul>
     * <li><code>obj</code> is an IResolvable</li>
     * <li><code>obj</code> is a string containing at least one encoded <code>IResolvable</code></li>
     * <li><code>obj</code> is either an encoded number or list</li>
     * </ul>
     * <p>This does NOT recurse into lists or objects to see if they
     * containing resolvables.</p>
     * 
     * @param obj The object to test. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isUnresolved(final java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "isUnresolved", java.lang.Boolean.class, new Object[] { obj });
    }
}
