package software.amazon.awscdk.core;

/**
 * Represents the building block of the construct graph.
 * 
 * <p>All constructs besides the root construct must be created within the scope of
 * another construct.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:09.456Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Construct")
public class Construct extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IConstruct {

    protected Construct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Construct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new construct node.
     * 
     * @param scope The scope in which to define this construct. This parameter is required.
     * @param id The scoped construct ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Construct(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return whether the given object is a Construct.
     * 
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isConstruct(final java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Construct.class, "isConstruct", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * Perform final modifications before synthesis.
     * 
     * <p>This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.</p>
     * <p>This is an advanced framework feature. Only use this if you
     * understand the implications.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void prepare() {
        this.jsiiCall("prepare", Void.class);
    }

    /**
     * Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * 
     * <p>This method is usually implemented by framework-level constructs such as <code>Stack</code> and <code>Asset</code>
     * as they participate in synthesizing the cloud assembly.</p>
     * 
     * @param session The synthesis session. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void synthesize(final software.amazon.awscdk.core.ISynthesisSession session) {
        this.jsiiCall("synthesize", Void.class, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Returns a string representation of this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Validate the current construct.
     * 
     * <p>This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.</p>
     * 
     * @return An array of validation error messages, or an empty array if there the construct is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * Construct tree node which offers APIs for interacting with the construct tree.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ConstructNode getNode() {
        return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
    }
}
